/*
 * Decompiled with CFR 0.152.
 */
package necesse.level.maps.presets;

import java.awt.Point;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import necesse.engine.util.GameRandom;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.friendly.human.HumanMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.objectEntity.SignObjectEntity;
import necesse.inventory.lootTable.LootTable;
import necesse.inventory.lootTable.LootTablePresets;
import necesse.inventory.lootTable.lootItem.LootItem;
import necesse.inventory.lootTable.presets.CaveRuinsLootTable;
import necesse.inventory.lootTable.presets.DeepCaveRuinsLootTable;
import necesse.level.maps.biomes.Biome;
import necesse.level.maps.presets.Preset;
import necesse.level.maps.presets.PresetUtils;

public class SlimeRanchPreset
extends Preset {
    public SlimeRanchPreset(Biome biome, LevelIdentifier levelIdentifier, GameRandom random) {
        super("PRESET = {\n\twidth = 28,\n\theight = 21,\n\ttileIDs = [32, swampstonebrickfloor, 17, willowfloor, 18, dryadfloor, 20, bamboofloor, 69, slimerocktile, 6, swampgrasstile, 7, overgrownswampgrasstile, 10, mudtile, 46, graveltile, 14, woodfloor, 31, swampstonefloor],\n\ttiles = [-1, -1, -1, -1, -1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, -1, -1, -1, -1, -1, -1, -1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, -1, -1, -1, 6, 6, 32, 32, 32, 6, 20, 17, 20, 20, 17, 6, 7, 7, 7, 7, 7, 6, 32, 32, 32, 32, 32, 32, 6, -1, -1, -1, 6, 6, 32, 32, 32, 6, 20, 20, 20, 20, 20, 6, 6, 7, 7, 7, 7, 6, 32, 32, 31, 32, 32, 32, 6, -1, -1, -1, 6, 6, 32, 6, 6, 6, 20, 20, 20, 20, 20, 20, 6, 7, 7, 7, 7, 6, 32, 32, 31, 32, 32, 32, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 6, 46, 46, 7, 7, 6, 32, 32, 32, 32, 32, 32, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 46, 46, 46, 46, 6, 46, 46, 46, 46, 46, 46, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 7, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 6, 46, 46, 46, 46, 46, 46, 46, 46, 7, 7, 7, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 6, 6, 6, 6, 6, 46, 46, 46, 7, 7, 7, 7, 7, 7, 7, 7, 6, -1, -1, -1, 17, 18, 18, 18, 18, 18, 18, 18, 6, 7, 7, 7, 7, 46, 46, 46, 7, 7, 7, 7, 7, 7, 7, 7, 6, -1, -1, -1, 17, 14, 14, 18, 18, 18, 18, 18, 6, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 7, 7, 7, 7, 7, 6, -1, -1, -1, 10, 6, 6, 6, 18, 18, 6, 6, 6, 46, 69, 7, 7, 7, 7, 7, 7, 7, 46, 46, 46, 46, 46, 6, 6, -1, -1, -1, -1, -1, 6, 6, 6, 6, 6, 6, 6, 46, 7, 7, 7, 7, 7, 7, 69, 7, 7, 7, 7, 7, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 6, 46, 7, 7, 7, 7, 69, 7, 7, 7, 7, 69, 69, 7, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 46, 46, 46, 46, 7, 7, 7, 7, 7, 7, 69, 69, 7, 46, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 46, 46, 46, 69, 7, 7, 7, 7, 7, 7, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, 46, 46, 46, 46, 46, 46, 46, 46, 46, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],\n\tobjectIDs = [0, air, 1024, feedingtrough2, 257, swamphedge, 322, swampcandlestand, 515, willowchest, 516, willowdinnertable, 133, swampstonewall, 517, willowdinnertable2, 390, sign, 519, willowmodulartable, 775, cuttingboard, 520, willowchair, 776, utensilrack1, 523, willowbookshelf, 524, willowcabinet, 780, greenandpinkbooks, 525, willowbed, 14, willowtree, 526, willowbed2, 16, willowlogbench, 784, greenbook, 17, willowlogbench2, 531, willowdresser, 532, willowclock, 533, willowcandelabra, 278, barrel, 535, willowbathtub, 536, willowbathtub2, 537, willowtoilet, 281, incinerator, 1181, swampgrass, 103, willowwall, 104, willowdoor, 1192, yellowflowerpatch, 108, willowwindow, 236, woodfence, 750, pottedplant3, 1137, slimecaverocksmall, 51, blackberrybush, 1013, cookingstation, 309, lantern, 1014, cookingstation2, 310, walllantern, 1336, swampcrate, 824, leftovertray, 825, leftovertray2, 444, mossysteppingstones, 1023, feedingtrough],\n\tobjects = [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 103, 103, 103, 103, 103, 103, 108, 103, 103, 103, 103, 257, 257, 257, 257, 257, 257, 133, 133, 133, 133, 133, 133, -1, -1, -1, -1, -1, 103, 535, 536, 322, 103, 515, 1013, 1014, 519, 519, 103, 1181, 1181, 0, 1181, 1181, 133, 133, 278, 1336, 278, 278, 133, 133, -1, -1, -1, -1, 103, 0, 0, 537, 103, 0, 0, 0, 0, 533, 103, 103, 281, 1181, 0, 1181, 133, 1336, 0, 0, 278, 0, 278, 133, -1, -1, -1, 103, 103, 104, 103, 103, 103, 0, 520, 520, 0, 0, 750, 103, 1181, 1181, 14, 1181, 133, 278, 0, 0, 0, 0, 278, 133, -1, -1, -1, 103, 533, 0, 0, 532, 533, 0, 517, 516, 520, 0, 0, 103, 0, -1, 51, 1181, 133, 1336, 0, 0, 0, 0, 1336, 133, -1, -1, -1, 103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 444, 0, -1, 1192, 133, 0, 0, 0, 0, 0, 310, 133, -1, -1, -1, 103, 523, 0, 520, 520, 0, 0, 0, 0, 0, 0, 0, 103, 0, 444, 0, 0, 310, 0, 0, 444, 0, 0, 0, 257, -1, -1, -1, 103, 0, 0, 519, 519, 0, 0, 0, 0, 0, 0, 0, 103, 0, 444, 444, 444, 444, 444, 0, 0, 0, 0, 1181, 257, -1, -1, -1, 108, 525, 0, 0, 0, 0, 0, 0, 533, 520, 519, 523, 103, 0, 444, 0, 0, 0, 0, 0, 0, 1181, 1181, 1181, 257, -1, -1, -1, 103, 526, 0, 0, 0, 0, 0, 0, 103, 103, 108, 103, 103, 0, 444, 0, 1181, 0, 1181, 1181, 1181, 1181, 0, 1181, 257, -1, -1, -1, 103, 531, 0, 0, 0, 0, 0, 0, 103, 0, 278, 0, 0, 0, 444, 0, 309, 0, 0, 0, 0, 1181, 1181, 1181, 257, -1, -1, -1, 103, 0, 0, 533, 0, 0, 0, 524, 103, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 1192, 1181, 1181, 1181, 14, 257, -1, -1, -1, 103, 108, 108, 103, 104, 104, 103, 108, 103, 236, 1137, 1181, 1181, 0, 1181, 1181, 1137, 1181, 236, 236, 236, 236, 236, 257, 257, -1, -1, -1, 0, 16, 17, 0, 1181, 0, 390, 0, 0, 236, 1181, 1181, 1181, 0, 1181, 1181, 0, 1181, 1181, 1181, 1023, 1024, 236, 0, -1, -1, -1, -1, 0, 0, 1181, 1181, 0, 1181, 0, 1181, 1181, 236, 1181, 1181, 1181, 1181, 0, 0, 1181, 1181, 1181, 0, 0, 1181, 236, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1181, 236, 236, 236, 236, 0, 1181, 1181, 1181, 0, 0, 0, 0, 1181, 236, 1181, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1181, 1181, 1181, 236, 236, 236, 0, 1181, 1181, 1137, 1181, 1181, 1181, 236, 1181, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1181, 0, 1181, 1181, 236, 236, 236, 236, 236, 236, 236, 236, 236, -1, -1, -1, -1, -1, -1, -1, -1, 1181, -1, -1, -1, -1, -1, -1, -1, -1, 1181, 1181, 0, -1, 0, -1, 0, 0, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1],\n\trotations = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 1, 2, 0, 0, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 2, 3, 0, 2, 2, 0, 0, 3, 3, 0, 0, 2, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 3, 0, 0, 2, 2, 0, 3, 3, 3, 0, 0, 3, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1, 1, 0, 2, 2, 3, 0, 0, 0, 0, 0, 0, 3, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 3, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 3, 0, 0, 3, 1, 1, 3, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 1, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 3, 2, 2, 3, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],\n\ttileObjectsClear = true,\n\twallDecorObjects = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 776, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],\n\twallDecorRotations = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],\n\ttableDecorObjects = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 775, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 824, 825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 784, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 780, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],\n\ttableDecorRotations = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],\n\tclearOtherWires = false\n}");
        this.addMob("swampslime", 13, 13, false);
        this.addMob("swampslime", 16, 13, false);
        this.addMob("swampslime", 17, 14, false);
        this.addMob("swampslime", 14, 15, false);
        this.addMob("giantswampslime", 20, 15, false);
        this.addMob("giantswampslime", 18, 16, false);
        this.addMob("giantswampslime", 15, 15, false);
        this.addSign("Slime Ranch", 7, 14);
        AtomicReference akHuman = new AtomicReference();
        this.addHuman("animalkeeperhuman", 7, 7, akHuman::set, random);
        this.addCustomApply(7, 14, 0, (level, levelX, levelY, dir, blackboard) -> {
            try {
                ObjectEntity objEnt = level.entityManager.getObjectEntity(levelX, levelY);
                if (objEnt instanceof SignObjectEntity) {
                    HumanMob humanMob = (HumanMob)akHuman.get();
                    if (humanMob != null) {
                        ((SignObjectEntity)objEnt).setText(humanMob.getSettlerName() + "'s Slime Ranch");
                    }
                } else if (level.isServer()) {
                    throw new NullPointerException("Could not find a sign objectEntity for preset at " + levelX + ", " + levelY);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            akHuman.set(null);
            return null;
        });
        LootTable barrelLoot = new LootTable(CaveRuinsLootTable.seeds1);
        LootTable chestLoot = LootTablePresets.surfaceRuinsChest;
        if (levelIdentifier == LevelIdentifier.CAVE_IDENTIFIER) {
            barrelLoot = new LootTable(CaveRuinsLootTable.seeds3);
            chestLoot = LootTablePresets.swampCaveRuinsChest;
        } else if (levelIdentifier == LevelIdentifier.DEEP_CAVE_IDENTIFIER) {
            barrelLoot = new LootTable(DeepCaveRuinsLootTable.deepSeeds3);
            chestLoot = LootTablePresets.deepSwampCaveChest;
        }
        ArrayList<Point> barrelPositions = new ArrayList<Point>();
        barrelPositions.add(new Point(20, 2));
        barrelPositions.add(new Point(22, 2));
        barrelPositions.add(new Point(22, 2));
        barrelPositions.add(new Point(23, 2));
        barrelPositions.add(new Point(22, 3));
        barrelPositions.add(new Point(24, 3));
        barrelPositions.add(new Point(19, 4));
        barrelPositions.add(new Point(24, 4));
        barrelPositions.add(new Point(11, 11));
        barrelPositions.add(new Point(21, 14));
        for (Point barrelPosition : barrelPositions) {
            if (!random.getChance(0.2f)) continue;
            this.addInventory(barrelLoot, random, barrelPosition.x, barrelPosition.y, new Object[0]);
        }
        this.addInventory(new LootTable(chestLoot), random, 7, 2, new Object[0]);
        this.addInventory(new LootTable(LootItem.between("wheat", 12, 25)), random, 21, 14, new Object[0]);
        PresetUtils.addShoreTiles(this, -1, -1, this.width + 2, this.height + 2);
    }
}

