/*
 * Decompiled with CFR 0.152.
 */
package necesse.inventory.recipe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.IncursionBiomeRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.engine.save.LoadData;
import necesse.engine.save.SaveSyntaxException;
import necesse.engine.util.GameRandom;
import necesse.inventory.item.miscItem.GatewayTabletItem;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.IngredientData;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.RecipeBrokerValueCompute;
import necesse.inventory.recipe.RecipeList;
import necesse.inventory.recipe.Tech;
import necesse.level.maps.incursion.IncursionBiome;

public class Recipes {
    private static RecipeList defaultRecipes = null;
    private static boolean canRegisterModRecipes = true;
    private static final List<Recipe> modRecipes = new ArrayList<Recipe>();

    public static void loadDefaultRecipes() {
        defaultRecipes = new RecipeList();
        defaultRecipes.addModRecipes(modRecipes);
    }

    public static RecipeBrokerValueCompute getDefaultBrokerValueCompute() {
        return new RecipeBrokerValueCompute(defaultRecipes);
    }

    public static void registerModRecipe(Recipe recipe) {
        if (!canRegisterModRecipes) {
            throw new IllegalStateException("Mod recipe registry is closed");
        }
        Objects.requireNonNull(recipe);
        modRecipes.add(recipe);
    }

    public static void closeModRecipeRegistry() {
        canRegisterModRecipes = false;
    }

    public static List<Recipe> getRecipesFromResult(int itemID) {
        return defaultRecipes.getRecipesFromResult(itemID);
    }

    public static List<Recipe> getRecipesFromIngredient(int itemID) {
        return defaultRecipes.getRecipesFromIngredient(itemID);
    }

    public static List<Recipe> getRecipesFromResultAndIngredient(int itemID) {
        return defaultRecipes.getRecipesFromResultAndIngredient(itemID);
    }

    public static boolean isCraftingMat(int itemID) {
        return defaultRecipes.isCraftingMat(itemID);
    }

    public static HashSet<Tech> getCraftingMatTechs(int itemID) {
        return defaultRecipes.getCraftingMatTechs(itemID);
    }

    public static int getHash() {
        return defaultRecipes.getHash();
    }

    public static int getDefaultHash() {
        return defaultRecipes.getHash();
    }

    public static Recipe getRecipe(int index) {
        return defaultRecipes.getRecipe(index);
    }

    public static Iterable<Recipe> getRecipes() {
        return defaultRecipes.getRecipes();
    }

    public static boolean hasRecipeHash(int recipeHash) {
        return defaultRecipes.hasRecipeHash(recipeHash);
    }

    public static int getRecipeIndexFromHash(int recipeHash) {
        return defaultRecipes.getRecipeIndexFromHash(recipeHash);
    }

    public static Recipe getRecipeFromHash(int recipeHash) {
        return defaultRecipes.getRecipeFromHash(recipeHash);
    }

    public static Stream<Recipe> streamRecipes() {
        return defaultRecipes.streamRecipes();
    }

    public static Iterable<Recipe> getRecipes(Tech tech) {
        return defaultRecipes.getRecipes(tech);
    }

    public static Iterable<Recipe> getRecipes(Tech ... techs) {
        return defaultRecipes.getRecipes(techs);
    }

    public static Stream<Recipe> streamRecipes(Tech ... techs) {
        return defaultRecipes.streamRecipes(techs);
    }

    public static int getTotalRecipes() {
        return defaultRecipes.getTotalRecipes();
    }

    public static int getDefaultTotalRecipes() {
        return defaultRecipes.getTotalRecipes();
    }

    public static Ingredient[] ingredientsFromScript(String script) {
        LoadData data = new LoadData(script);
        if (!data.isArray()) {
            throw new SaveSyntaxException("Ingredients script is not an array");
        }
        List<LoadData> ingredientsSave = data.getLoadData();
        Ingredient[] ingredients = new Ingredient[ingredientsSave.size()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = new IngredientData(ingredientsSave.get(i), null).validate();
        }
        return ingredients;
    }

    /*
     * Opcode count of 16076 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static ArrayList<Recipe> getDefaultRecipes() {
        ArrayList<Recipe> out = new ArrayList<Recipe>();
        out.add(new Recipe("upgradestation", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier1essence, 10}, {upgradeshard, 10}}")));
        out.add(new Recipe("salvagestation", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier1essence, 10}, {upgradeshard, 10}}")));
        out.add(new Recipe("greaterlifeelixir", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{lifeelixir, 1}, {alchemyshard, 100}}")));
        out.add(new Recipe("gatewaytablet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{tungstenbar, 10}, {ectoplasm, 10}}"), false, new GNDItemMap().setString("recipeBiome", "forestcave").setInt("displayTier", 1)).onCrafted(event -> {
            event.resultItem.getGndData().clearItem("recipeBiome");
            event.resultItem.getGndData().clearItem("displayTier");
            IncursionBiome biome = IncursionBiomeRegistry.getBiome("forestcave");
            GatewayTabletItem.initializeCustomGateTablet(event.resultItem, GameRandom.globalRandom, 1, biome);
        }));
        out.add(new Recipe("gatewaytablet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{glacialbar, 10}, {glacialshard, 10}}"), false, new GNDItemMap().setString("recipeBiome", "snowcave").setInt("displayTier", 1)).onCrafted(event -> {
            event.resultItem.getGndData().clearItem("recipeBiome");
            event.resultItem.getGndData().clearItem("displayTier");
            IncursionBiome biome = IncursionBiomeRegistry.getBiome("snowcave");
            GatewayTabletItem.initializeCustomGateTablet(event.resultItem, GameRandom.globalRandom, 1, biome);
        }));
        out.add(new Recipe("gatewaytablet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{myceliumbar, 10}, {silk, 10}}"), false, new GNDItemMap().setString("recipeBiome", "swampcave").setInt("displayTier", 1)).onCrafted(event -> {
            event.resultItem.getGndData().clearItem("recipeBiome");
            event.resultItem.getGndData().clearItem("displayTier");
            IncursionBiome biome = IncursionBiomeRegistry.getBiome("swampcave");
            GatewayTabletItem.initializeCustomGateTablet(event.resultItem, GameRandom.globalRandom, 1, biome);
        }));
        out.add(new Recipe("gatewaytablet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{ancientfossilbar, 10}, {wormcarapace, 5}}"), false, new GNDItemMap().setString("recipeBiome", "desertcave").setInt("displayTier", 1)).onCrafted(event -> {
            event.resultItem.getGndData().clearItem("recipeBiome");
            event.resultItem.getGndData().clearItem("displayTier");
            IncursionBiome biome = IncursionBiomeRegistry.getBiome("desertcave");
            GatewayTabletItem.initializeCustomGateTablet(event.resultItem, GameRandom.globalRandom, 1, biome);
        }));
        out.add(new Recipe("shadowessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 3}}")));
        out.add(new Recipe("cryoessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 3}}")));
        out.add(new Recipe("bioessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 3}}")));
        out.add(new Recipe("primordialessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 3}}")));
        out.add(new Recipe("slimeessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 4}}")));
        out.add(new Recipe("bloodessence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 4}}")));
        out.add(new Recipe("spideressence", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 4}}")));
        out.add(new Recipe("omnicrystal", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anytier2essence, 4}}")).setCraftingCategory("incursions"));
        out.add(new Recipe("gatewaytablet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{ascendedshard, 5}}"), false, new GNDItemMap().setString("recipeBiome", "settlementruins").setInt("displayTier", 10)).onCrafted(event -> {
            event.resultItem.getGndData().setItem("recipeBiome", null);
            IncursionBiome biome = IncursionBiomeRegistry.getBiome("settlementruins");
            GatewayTabletItem.initializeCustomGateTablet(event.resultItem, GameRandom.globalRandom, 10, biome);
        }));
        out.add(new Recipe("firestone", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("froststone", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("spikedboots", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("scryingmirror", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("diggingclaw", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("clockworkheart", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("gelatincasings", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{slimematter, 20}, {slimeum, 12}}")));
        out.add(new Recipe("potionbag", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{potionpouch, 1}, {shadowessence, 5}, {cryoessence, 5}, {bioessence, 5}, {primordialessence, 5}}")).onCrafted(event -> event.itemsUsed.stream().filter(item -> item.invItem.item.getStringID().equals("potionpouch")).findFirst().ifPresent(previousPouch -> event.resultItem.setGndData(previousPouch.invItem.getGndData()))));
        out.add(new Recipe("ammobag", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{ammopouch, 1}, {shadowessence, 5}, {cryoessence, 5}, {bioessence, 5}, {primordialessence, 5}}")).onCrafted(event -> event.itemsUsed.stream().filter(item -> item.invItem.item.getStringID().equals("ammopouch")).findFirst().ifPresent(previousPouch -> event.resultItem.setGndData(previousPouch.invItem.getGndData()))));
        out.add(new Recipe("slimegreatsword", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimeessence, 5}, {slimematter, 12}, {slimeum, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimeglaive", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimeessence, 5}, {slimematter, 20}, {slimeum, 16}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimestaff", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimeessence, 5}, {slimematter, 20}, {slimeum, 16}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimegreatbow", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimeessence, 5}, {slimematter, 16}, {slimeum, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("orbofslimes", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimeessence, 5}, {slimematter, 16}, {slimeum, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimehelmet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimematter, 24}, {slimeum, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimehat", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimematter, 24}, {slimeum, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimechestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimematter, 32}, {slimeum, 32}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("slimeboots", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{slimematter, 16}, {slimeum, 16}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightrazorboomerang", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bloodessence, 2}, {nightsteelbar, 5}, {phantomdust, 5}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightpiercer", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bloodessence, 5}, {nightsteelbar, 20}, {phantomdust, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("phantompopper", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bloodessence, 5}, {nightsteelbar, 16}, {phantomdust, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("phantomcaller", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bloodessence, 5}, {nightsteelbar, 12}, {phantomdust, 32}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelhelmet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 12}, {phantomdust, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelmask", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 12}, {phantomdust, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelveil", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 12}, {phantomdust, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelcirclet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 12}, {phantomdust, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelchestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 16}, {phantomdust, 32}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("nightsteelboots", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{nightsteelbar, 8}, {phantomdust, 16}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("causticexecutioner", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideressence, 5}, {spideritebar, 18}, {spidervenom, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("arachnidwebbow", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideressence, 5}, {spideritebar, 15}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("webweaver", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideressence, 5}, {spideritebar, 20}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("empresscommand", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideressence, 5}, {spideritebar, 25}, {spidervenom, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritehelmet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 12}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritehood", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 12}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritehat", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 12}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritecrown", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 12}, {spidervenom, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritechestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 16}, {spidervenom, 30}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("spideritegreaves", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 8}, {spidervenom, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("gemstonelongsword", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{amethyst, 15}, {pearlescentdiamond, 15}, {omnicrystal, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("shardcannon", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{sapphire, 15}, {pearlescentdiamond, 15}, {omnicrystal, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("refractor", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{emerald, 15}, {pearlescentdiamond, 15}, {omnicrystal, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("crystallizedskull", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ruby, 15}, {pearlescentdiamond, 15}, {omnicrystal, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("amethysthelmet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{amethyst, 12}, {pearlescentdiamond, 5}, {omnicrystal, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("sapphireeyepatch", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{sapphire, 12}, {pearlescentdiamond, 5}, {omnicrystal, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("emeraldmask", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{emerald, 12}, {pearlescentdiamond, 5}, {omnicrystal, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("rubycrown", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ruby, 12}, {pearlescentdiamond, 5}, {omnicrystal, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("crystalchestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{pearlescentdiamond, 16}, {omnicrystal, 30}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("crystalboots", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{pearlescentdiamond, 8}, {omnicrystal, 15}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("crystalshield", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{pearlescentdiamond, 15}, {omnicrystal, 15}}")));
        out.add(new Recipe("ravenwinggreatsword", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 26}, {bloodessence, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("ravenbeakspear", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 26}, {slimeessence, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("theravensnest", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 26}, {spideressence, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("ravenlordsheaddress", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 18}, {anytier2essence, 14}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("ravenlordschestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 24}, {anytier2essence, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("ravenlordsboots", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{ravenfeather, 12}, {anytier2essence, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("perfectstorm", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{electrifiedmana, 30}, {omnicrystal, 24}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("arcanichelmet", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{electrifiedmana, 18}, {omnicrystal, 14}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("arcanicchestplate", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{electrifiedmana, 24}, {omnicrystal, 20}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("arcanicboots", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{electrifiedmana, 12}, {omnicrystal, 10}}"), false, new GNDItemMap().setInt("upgradeLevel", 100)));
        out.add(new Recipe("antiquerifle", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("dragonsrebound", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("dragonlance", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("bowofdualism", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("skeletonstaff", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{primordialessence, 20}}")));
        out.add(new Recipe("agedchampionshield", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("swampdwellerstaff", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("druidsgreatbow", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("venomshower", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("venomslasher", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("livingshotty", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("swampsgrasp", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{bioessence, 20}}")));
        out.add(new Recipe("siphonshield", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("icepickaxe", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("cryoquake", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("cryospear", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("cryoblaster", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("cryoglaive", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{cryoessence, 20}}")));
        out.add(new Recipe("elderlywand", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("depthscatcher", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("shadowbeam", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("reaperscall", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("deathripper", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("reaperscythe", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{shadowessence, 20}}")));
        out.add(new Recipe("fallenanvil", 1, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{anytier1essence, 10}, {upgradeshard, 10}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("greaterbattlepotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{battlepotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterhealthregenpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{healthregenpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greatermanaregenpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{manaregenpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterspeedpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{speedpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterattackspeedpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{attackspeedpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greateraccuracypotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{accuracypotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterrapidpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{rapidpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterresistancepotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{resistancepotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterminingpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{miningpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterbuildingpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{buildingpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("greaterfishingpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{fishingpotion, 1}, {alchemyshard, 10}}")));
        out.add(new Recipe("fallenalchemytable", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{anytier1essence, 10}, {alchemyshard, 10}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("fallenaltar", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{gatewaytablet, 0}, {tungstenbar, 10}, {glacialbar, 10}, {myceliumbar, 10}, {ancientfossilbar, 10}}")));
        out.add(new Recipe("cookingstation", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{tungstenbar, 8}, {obsidian, 12}}")));
        out.add(new Recipe("landscapingstation", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 20}, {anylog, 15}, {firemone, 4}}")));
        out.add(new Recipe("lifeelixir", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{lifequartz, 10}, {sunflower, 10}, {glassbottle, 1}}")));
        out.add(new Recipe("shadowgate", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{tungstenbar, 4}, {ectoplasm, 8}, {bone, 8}}")));
        out.add(new Recipe("spiriturn", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{amber, 8}, {dryadlog, 8}}")));
        out.add(new Recipe("icecrown", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{glacialbar, 4}, {glacialshard, 8}, {bone, 8}}")));
        out.add(new Recipe("decayingleaf", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{myceliumbar, 4}, {silk, 8}, {bone, 8}}")));
        out.add(new Recipe("dragonsouls", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{ancientfossilbar, 4}, {wormcarapace, 4}, {bone, 8}}")));
        out.add(new Recipe("bonehilt", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{bone, 40}, {tungstenbar, 4}}")));
        out.add(new Recipe("frenzyorb", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{ectoplasm, 15}, {voidshard, 5}}")));
        out.add(new Recipe("lifependant", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{lifequartz, 10}, {tungstenbar, 4}, {regenpendant, 1}}")));
        out.add(new Recipe("spellstone", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{sparegemstones, 1}, {ectoplasm, 10}}")));
        out.add(new Recipe("manica", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{chainshirt, 1}, {vambrace, 1}}")));
        out.add(new Recipe("ghostboots", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{windboots, 1}, {ectoplasm, 20}}")));
        out.add(new Recipe("explorercloak", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{travelercloak, 1}, {piratetelescope, 1}}")));
        out.add(new Recipe("ancientrelics", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{airvessel, 1}, {templependant, 1}}")));
        out.add(new Recipe("spikedbatboots", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{vampiresgift, 1}, {spikedboots, 1}}")));
        out.add(new Recipe("frostflame", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{firestone, 1}, {froststone, 1}}")));
        out.add(new Recipe("balancedfrostfirefoci", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{balancedfoci, 1}, {frostflame, 1}}")));
        out.add(new Recipe("hysteriatablet", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{mesmertablet, 1}, {inducingamulet, 1}}")));
        out.add(new Recipe("frozensoul", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{lifeline, 1}, {frozenheart, 1}}")));
        out.add(new Recipe("toolbox", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{constructionhammer, 1}, {telescopicladder, 1}, {toolextender, 1}, {itemattractor, 1}}")));
        out.add(new Recipe("essenceofrebirth", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{essenceofperspective, 1}, {essenceofprolonging, 1}, {lifequartz, 10}}")));
        out.add(new Recipe("deepladderdown", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{tungstenbar, 8}}")));
        out.add(new Recipe("tungstenpickaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}}")));
        out.add(new Recipe("tungstenaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}}")));
        out.add(new Recipe("tungstenshovel", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}}")));
        out.add(new Recipe("tungstensword", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 12}}")));
        out.add(new Recipe("tungstenspear", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 18}}")));
        out.add(new Recipe("tungstenboomerang", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 4}, {obsidian, 5}}")));
        out.add(new Recipe("tungstenbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 12}}")));
        out.add(new Recipe("tungstengreatbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}, {ectoplasm, 8}}")));
        out.add(new Recipe("tungstenhelmet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 12}, {obsidian, 12}}")));
        out.add(new Recipe("tungstenchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}, {obsidian, 16}}")));
        out.add(new Recipe("tungstenboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 8}, {obsidian, 8}}")));
        out.add(new Recipe("tungstenshield", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 16}, {obsidian, 8}}")));
        out.add(new Recipe("reinforcedkatana", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{katana, 1}, {tungstenbar, 15}}")));
        out.add(new Recipe("shadowhat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ectoplasm, 12}, {bone, 10}}")));
        out.add(new Recipe("shadowhood", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ectoplasm, 12}, {bone, 10}}")));
        out.add(new Recipe("shadowmantle", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ectoplasm, 16}, {bone, 14}}")));
        out.add(new Recipe("shadowboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ectoplasm, 8}, {bone, 8}}")));
        out.add(new Recipe("shadowbolt", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ectoplasm, 15}, {book, 1}}")));
        out.add(new Recipe("soulseedcrown", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ivycirclet, 1}, {caveglow, 4}, {ruby, 5}}")));
        out.add(new Recipe("soulseedchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ivychestplate, 1}, {caveglow, 5}, {obsidian, 20}}}")));
        out.add(new Recipe("soulseedboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ivyboots, 1}, {obsidian, 10}, {ruby, 5}}}")));
        out.add(new Recipe("glacialpickaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 16}}")));
        out.add(new Recipe("glacialaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 16}}")));
        out.add(new Recipe("glacialshovel", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 16}}")));
        out.add(new Recipe("glacialgreatsword", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 20}, {glacialshard, 12}}")));
        out.add(new Recipe("glacialboomerang", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 4}, {glacialshard, 4}}")));
        out.add(new Recipe("glacialbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 12}, {glacialshard, 5}}")));
        out.add(new Recipe("glacialcirclet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 12}, {glacialshard, 3}}")));
        out.add(new Recipe("glacialhelmet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 12}, {glacialshard, 3}}")));
        out.add(new Recipe("glacialchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 16}, {glacialshard, 5}}")));
        out.add(new Recipe("glacialboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 8}, {glacialshard, 2}}")));
        out.add(new Recipe("iciclestaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 12}, {glacialshard, 6}}")));
        out.add(new Recipe("cryostaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{glacialbar, 14}, {glacialshard, 15}}")));
        out.add(new Recipe("deepfrosthood", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{frosthood, 1}, {glacialbar, 3}, {glacialshard, 6}}")));
        out.add(new Recipe("deepfrostchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{frostchestplate, 1}, {glacialbar, 6}, {bonearrow, 50}}")));
        out.add(new Recipe("deepfrostboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{frostboots, 1}, {glacialbar, 3}, {glacialshard, 6}}")));
        out.add(new Recipe("cryowitchhat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{witchhat, 1}, {glacialbar, 6}, {icecrown, 1}}")));
        out.add(new Recipe("cryowitchrobe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{witchrobe, 1}, {glacialbar, 6}, {glacialshard, 5}}")));
        out.add(new Recipe("cryowitchshoes", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{witchshoes, 1}, {glacialbar, 4}, {glacialshard, 5}}")));
        out.add(new Recipe("dryadpickaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 13}, {dryadlog, 6}}")));
        out.add(new Recipe("dryadaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 13}, {dryadlog, 6}}")));
        out.add(new Recipe("dryadshovel", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 13}, {dryadlog, 6}}")));
        out.add(new Recipe("dryadgreathammer", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 20}}")));
        out.add(new Recipe("dryadbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 16}, {dryadlog, 10}}")));
        out.add(new Recipe("dryadbarrage", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 16}, {dryadlog, 10}}")));
        out.add(new Recipe("dryadbranch", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 20}}")));
        out.add(new Recipe("dryadcrown", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 3}}")));
        out.add(new Recipe("dryadhat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 3}}")));
        out.add(new Recipe("dryadhelmet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 3}}")));
        out.add(new Recipe("dryadscarf", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 12}, {dryadlog, 3}}")));
        out.add(new Recipe("dryadchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 16}, {dryadlog, 5}}")));
        out.add(new Recipe("dryadboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{amber, 8}, {dryadlog, 2}}")));
        out.add(new Recipe("myceliumpickaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 16}}")));
        out.add(new Recipe("myceliumaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 16}}")));
        out.add(new Recipe("myceliumshovel", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 16}}")));
        out.add(new Recipe("myceliumgreatbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 20}}")));
        out.add(new Recipe("myceliumhood", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 12}}")));
        out.add(new Recipe("myceliumscarf", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 12}}")));
        out.add(new Recipe("myceliumchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 16}}")));
        out.add(new Recipe("myceliumboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{myceliumbar, 8}}")));
        out.add(new Recipe("widowhelmet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{silk, 12}, {myceliumbar, 8}, {cavespidergland, 6}}")));
        out.add(new Recipe("widowchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{silk, 16}, {myceliumbar, 10}, {cavespidergland, 8}}")));
        out.add(new Recipe("widowboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{silk, 8}, {myceliumbar, 6}, {cavespidergland, 4}}")));
        out.add(new Recipe("ancientfossilpickaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}}")));
        out.add(new Recipe("ancientfossilaxe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}}")));
        out.add(new Recipe("ancientfossilshovel", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}}")));
        out.add(new Recipe("ancientdredgingstaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{dredgingstaff, 1}, {ancientfossilbar, 15}}")));
        out.add(new Recipe("sandknife", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{quartz, 20}, {ancientfossilbar, 5}, {wormcarapace, 5}}")));
        out.add(new Recipe("carapacedagger", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{bonehilt, 1}, {wormcarapace, 5}}")));
        out.add(new Recipe("carapaceshield", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{wormcarapace, 15}}")));
        out.add(new Recipe("ancientfossilmask", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 8}, {wormcarapace, 5}}")));
        out.add(new Recipe("ancientfossilhelmet", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 12}, {wormcarapace, 3}}")));
        out.add(new Recipe("ancientfossilchestplate", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}, {wormcarapace, 4}}")));
        out.add(new Recipe("ancientfossilboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 8}, {wormcarapace, 2}}")));
        out.add(new Recipe("sharpshooterhat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 12}, {wormcarapace, 3}}")));
        out.add(new Recipe("sharpshootercoat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}, {wormcarapace, 4}}")));
        out.add(new Recipe("sharpshooterboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 8}, {wormcarapace, 2}}")));
        out.add(new Recipe("ancestorshat", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 12}, {wormcarapace, 3}, {dryadlog, 6}}")));
        out.add(new Recipe("ancestorsrobe", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 16}, {wormcarapace, 4}, {dryadlog, 10}}")));
        out.add(new Recipe("ancestorsboots", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ancientfossilbar, 8}, {wormcarapace, 2}, {dryadlog, 4}}")));
        out.add(new Recipe("chefsspecial", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{rollingpin, 1}, {butcherscleaver, 1}}")));
        out.add(new Recipe("galvanichammer", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{lightninghammer, 1}, {runestone, 10}, {tungstenbar, 5}}")));
        out.add(new Recipe("rubyshields", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ruby, 18}}")));
        out.add(new Recipe("emeraldwand", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{emerald, 15}, {goldbar, 2}}")));
        out.add(new Recipe("hexedbladegreatsword", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{necroticgreatsword, 1}, {goldbar, 5}, {voidshard, 5}, {ivybar, 5}, {quartz, 5}, {tungstenbar, 5}}")));
        out.add(new Recipe("reanimationbow", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{necroticbow, 1}, {bone, 100}}")));
        out.add(new Recipe("unlabeledpotion", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{necroticflask, 1}, {sapphire, 2}, {amethyst, 2}, {ruby, 2}, {emerald, 2}, {battlepotion, 1}, {attackspeedpotion, 1}, {fireresistancepotion, 1}, {thornspotion, 1}}")));
        out.add(new Recipe("vampiriclamp", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{genielamp, 1}, {batwing, 20}, {lifequartz, 10}}")));
        out.add(new Recipe("chromaticspellbook", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{bloodvolley, 1}, {shadowbolt, 1}, {swamptome, 1}}")));
        out.add(new Recipe("tungstenanvil", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{tungstenbar, 6}, {quartz, 8}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("strengthpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{obsidian, 2}, {caveglow, 2}, {rockfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("rangerpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{bone, 1}, {caveglow, 2}, {swampfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("wisdompotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{ectoplasm, 1}, {caveglow, 2}, {furfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("minionpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{glacialshard, 1}, {caveglow, 2}, {icefish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("webpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{silk, 1}, {caveglow, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("treasurepotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{ectoplasm, 2}, {iceblossom, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("caveglowalchemytable", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{glassbottle, 6}, {caveglow, 12}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("cheesepress", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 5}, {demonicbar, 5}}")));
        out.add(new Recipe("boneoffering", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {runestone, 2}, {voidshard, 4}}")));
        out.add(new Recipe("spikedfossil", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {ivybar, 4}, {voidshard, 4}}")));
        out.add(new Recipe("ancientstatue", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {quartz, 4}, {voidshard, 4}}")));
        out.add(new Recipe("voidcaller", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {voidshard, 4}}")));
        out.add(new Recipe("royalegg", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {frostshard, 4}, {cavespidergland, 4}}")));
        out.add(new Recipe("mysteriousportal", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 4}, {batwing, 4}}")));
        out.add(new Recipe("villagemap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 2}}")));
        out.add(new Recipe("dungeonmap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 2}}")));
        out.add(new Recipe("chieftainmap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 4}, {runestone, 4}}")));
        out.add(new Recipe("piratemap", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 4}, {coin, 500}}")));
        out.add(new Recipe("cronemap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 4}, {amber, 8}}")));
        out.add(new Recipe("sagegritmap", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{mapfragment, 4}, {ancientfossilbar, 8}}")));
        out.add(new Recipe("arcanearmory", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 10}, {voidshard, 10}, {ivybar, 10}, {quartz, 10}}")));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 3}}")));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}}")));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{goldbar, 1}}")));
        out.add(new Recipe("bannerofspeed", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{wool, 30}, {speedpotion, 10}}")));
        out.add(new Recipe("bannerofdamage", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{wool, 30}, {battlepotion, 10}}")));
        out.add(new Recipe("bannerofdefense", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{wool, 30}, {resistancepotion, 10}}")));
        out.add(new Recipe("bannerofsummonspeed", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{wool, 30}, {voidshard, 20}}")));
        out.add(new Recipe("balancedfoci", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{meleefoci, 1}, {rangefoci, 1}, {magicfoci, 1}, {summonfoci, 1}}")));
        out.add(new Recipe("windboots", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{zephyrboots, 1}, {forceofwind, 1}, {runestone, 4}}")));
        out.add(new Recipe("explorersatchel", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{leatherglove, 1}, {trackerboot, 1}, {shinebelt, 1}}")));
        out.add(new Recipe("shellofretribution", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{cactusshield, 1}, {spidercharm, 1}}")));
        out.add(new Recipe("assassinscowl", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{luckycape, 1}, {ancientfeather, 1}}")));
        out.add(new Recipe("demonclaw", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 5}}")));
        out.add(new Recipe("nightmaretalisman", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{dreamcatcher, 1}, {voidshard, 10}}")));
        out.add(new Recipe("scryingcards", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{prophecyslab, 1}, {magicmanual, 1}}")));
        out.add(new Recipe("travelercloak", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{mobilitycloak, 1}, {fins, 1}}")));
        out.add(new Recipe("calmingminersbouquet", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{calmingrose, 1}, {miningcharm, 1}}")));
        out.add(new Recipe("chainshirt", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}, {leather, 10}}")));
        out.add(new Recipe("fins", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sharkscales, 8}}")));
        out.add(new Recipe("apiary", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 20}, {ironbar, 10}, {honey, 5}}")));
        out.add(new Recipe("apiaryframe", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 5}, {wool, 5}}")).setCraftingCategory("objects"));
        out.add(new Recipe("net", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {wool, 5}}")).setCraftingCategory("objects"));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 3}}")));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 2}}")));
        out.add(new Recipe("demonicbar", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 1}}")));
        out.add(new Recipe("demonicpickaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 10}}")));
        out.add(new Recipe("demonicaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 10}}")));
        out.add(new Recipe("demonicshovel", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 10}}")));
        out.add(new Recipe("demonicsword", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 12}}")));
        out.add(new Recipe("demonicspear", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 18}}")));
        out.add(new Recipe("demonicbow", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 12}}")));
        out.add(new Recipe("demonichelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 12}, {voidshard, 1}}")));
        out.add(new Recipe("demonicchestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 16}, {voidshard, 1}}")));
        out.add(new Recipe("demonicboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 8}, {voidshard, 1}}")));
        out.add(new Recipe("amethystsword", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{amethyst, 15}, {goldbar, 2}}")));
        out.add(new Recipe("sapphirerevolver", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{sapphire, 15}, {goldbar, 2}}")));
        out.add(new Recipe("sprinkler", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{sapphire, 10}, {sparkler, 1}}")));
        out.add(new Recipe("voidmask", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{wool, 12}, {voidshard, 4}}")));
        out.add(new Recipe("voidhat", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{wool, 12}, {voidshard, 4}}")));
        out.add(new Recipe("voidrobe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{wool, 16}, {voidshard, 6}}")));
        out.add(new Recipe("voidboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{wool, 8}, {voidshard, 3}}")));
        out.add(new Recipe("voidspear", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{voidshard, 16}, {demonicbar, 8}}")));
        out.add(new Recipe("voidboomerang", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{voidshard, 4}, {demonicbar, 2}}")));
        out.add(new Recipe("voidgreatbow", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{voidshard, 16}, {demonicbar, 8}}")));
        out.add(new Recipe("bloodbolt", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{book, 1}, {batwing, 10}}")));
        out.add(new Recipe("bloodvolley", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{bloodbolt, 1}, {voidshard, 10}, {batwing, 10}}")));
        out.add(new Recipe("thiefscowl", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{goldhelmet, 1}, {voidshard, 2}, {sapphire, 2}}")));
        out.add(new Recipe("thiefscloak", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{goldchestplate, 1}, {voidshard, 3}, {coin, 100}}")));
        out.add(new Recipe("thiefsboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{goldboots, 1}, {coin, 75}, {sapphire, 1}}")));
        out.add(new Recipe("bloodplatecowl", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 14}, {batwing, 8}}")));
        out.add(new Recipe("bloodplatechestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 18}, {batwing, 10}}")));
        out.add(new Recipe("bloodplateboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 10}, {batwing, 6}}")));
        out.add(new Recipe("arachnidhelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{spiderhelmet, 1}, {frostshard, 2}, {royalegg, 1}}")));
        out.add(new Recipe("arachnidchestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{spiderchestplate, 1}, {frostshard, 4}, {cavespidergland, 2}}}")));
        out.add(new Recipe("arachnidlegs", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{spiderboots, 1}, {frostshard, 2}, {cavespidergland, 1}}}")));
        out.add(new Recipe("runicpickaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 10}}")));
        out.add(new Recipe("runicaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 10}}")));
        out.add(new Recipe("runicshovel", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 10}}")));
        out.add(new Recipe("runichelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 12}, {clothscraps, 8}}")));
        out.add(new Recipe("runichood", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 10}, {clothscraps, 10}}")));
        out.add(new Recipe("runichat", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 8}, {clothscraps, 12}}")));
        out.add(new Recipe("runiccrown", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 9}, {clothscraps, 11}}")));
        out.add(new Recipe("runicchestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 15}, {clothscraps, 9}}")));
        out.add(new Recipe("runicboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runestone, 8}, {clothscraps, 6}}")));
        out.add(new Recipe("pharaohsheaddress", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runichood, 1}, {clothhat, 1}, {amethyst, 2}}")));
        out.add(new Recipe("pharaohsrobe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runicchestplate, 1}, {clothrobe, 1}, {clothscraps, 6}}")));
        out.add(new Recipe("pharaohssandals", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{runicboots, 1}, {clothboots, 1}, {goldbar, 2}}")));
        out.add(new Recipe("ivypickaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 10}}")));
        out.add(new Recipe("ivyaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 10}}")));
        out.add(new Recipe("ivyshovel", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 10}}")));
        out.add(new Recipe("ivysword", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}}")));
        out.add(new Recipe("ivygreatsword", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 20}}")));
        out.add(new Recipe("ivyspear", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 18}}")));
        out.add(new Recipe("ivybow", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}}")));
        out.add(new Recipe("ivygreatbow", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 16}, {swampsludge, 8}}")));
        out.add(new Recipe("boulderstaff", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 14}, {swampsludge, 10}, {voidshard, 5}}")));
        out.add(new Recipe("ivyhelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}, {swampsludge, 6}}")));
        out.add(new Recipe("ivyhood", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}, {swampsludge, 6}}")));
        out.add(new Recipe("ivyhat", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}, {swampsludge, 6}}")));
        out.add(new Recipe("ivycirclet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 12}, {swampsludge, 6}}")));
        out.add(new Recipe("ivychestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 16}, {swampsludge, 8}}")));
        out.add(new Recipe("ivyboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ivybar, 8}, {swampsludge, 4}}")));
        out.add(new Recipe("quartzpickaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 10}}")));
        out.add(new Recipe("quartzaxe", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 10}}")));
        out.add(new Recipe("quartzshovel", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 10}}")));
        out.add(new Recipe("quartzgreatsword", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 20}}")));
        out.add(new Recipe("quartzglaive", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 15}}")));
        out.add(new Recipe("quartzstaff", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 10}, {voidshard, 5}}")));
        out.add(new Recipe("quartzhelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 12}}")));
        out.add(new Recipe("quartzcrown", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 12}}")));
        out.add(new Recipe("quartzchestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 16}}")));
        out.add(new Recipe("quartzboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{quartz, 8}}")));
        out.add(new Recipe("gunslingerhat", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{leather, 10}, {quartz, 10}}")));
        out.add(new Recipe("gunslingervest", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{leather, 12}, {quartz, 14}}")));
        out.add(new Recipe("gunslingerboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{leather, 8}, {quartz, 6}}")));
        out.add(new Recipe("demonicanvil", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{demonicbar, 5}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("woodpickaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodshovel", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodfishingrod", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 1}, {anysapling, 1}}")));
        out.add(new Recipe("woodsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodspear", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 15}}")));
        out.add(new Recipe("woodbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodboomerang", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("leatherhood", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{leather, 12}}")));
        out.add(new Recipe("leathershirt", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{leather, 16}}")));
        out.add(new Recipe("leatherboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{leather, 8}}")));
        out.add(new Recipe("clothhat", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{wool, 12}}")));
        out.add(new Recipe("clothrobe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{wool, 16}}")));
        out.add(new Recipe("clothboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{wool, 8}}")));
        out.add(new Recipe("copperhelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 12}}")));
        out.add(new Recipe("copperchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 16}}")));
        out.add(new Recipe("copperboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 8}}")));
        out.add(new Recipe("copperpickaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("copperaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("coppershovel", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("coppersword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 10}, {anylog, 1}}")));
        out.add(new Recipe("copperspear", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 15}, {anylog, 2}}")));
        out.add(new Recipe("copperbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{copperbar, 10}}")));
        out.add(new Recipe("ironhelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 12}}")));
        out.add(new Recipe("ironchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 16}}")));
        out.add(new Recipe("ironboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 8}}")));
        out.add(new Recipe("ironpickaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("ironaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("ironshovel", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("ironsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 10}, {anylog, 1}}")));
        out.add(new Recipe("irongreatsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 20}, {anylog, 2}}")));
        out.add(new Recipe("ironspear", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 15}, {anylog, 2}}")));
        out.add(new Recipe("ironbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 10}}")));
        out.add(new Recipe("goldcrown", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 12}}")));
        out.add(new Recipe("goldhelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 12}}")));
        out.add(new Recipe("goldchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 16}}")));
        out.add(new Recipe("goldboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 8}}")));
        out.add(new Recipe("goldpickaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("goldaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("goldshovel", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 8}, {anylog, 1}}")));
        out.add(new Recipe("goldsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 10}, {anylog, 1}}")));
        out.add(new Recipe("goldspear", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 15}, {anylog, 2}}")));
        out.add(new Recipe("goldglaive", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 16}}")));
        out.add(new Recipe("goldbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 10}}")));
        out.add(new Recipe("goldgreatbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{goldbar, 16}}")));
        out.add(new Recipe("woodstaff", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}, {goldbar, 5}, {batwing, 2}}")));
        out.add(new Recipe("sparkler", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{torch, 10}, {ironbar, 2}, {goldbar, 2}, {anylog, 5}}")));
        out.add(new Recipe("soldiercap", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironhelmet, 1}, {leatherhood, 1}, {goldbar, 1}, {wool, 2}}")));
        out.add(new Recipe("soldierhelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironhelmet, 1}, {leatherhood, 1}, {goldbar, 2}}")));
        out.add(new Recipe("soldierchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironchestplate, 1}, {leathershirt, 1}, {copperbar, 2}}")));
        out.add(new Recipe("soldierboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironboots, 1}, {leatherboots, 1}, {wool, 1}}")));
        out.add(new Recipe("sharkarmorhelmet", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ironhelmet, 1}, {ironbar, 6}, {sharktooth, 2}}")));
        out.add(new Recipe("sharkarmorchestplate", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ironchestplate, 1}, {sharkscales, 4}, {wool, 4}}")));
        out.add(new Recipe("sharkarmorboots", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{ironboots, 1}, {fins, 1}, {wool, 3}}")));
        out.add(new Recipe("spiderhelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 7}}")));
        out.add(new Recipe("spiderchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 10}}")));
        out.add(new Recipe("spiderboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 4}}")));
        out.add(new Recipe("spiderboomerang", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 8}}")));
        out.add(new Recipe("venomstaff", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 10}}")));
        out.add(new Recipe("spiderstaff", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{cavespidergland, 12}}")));
        out.add(new Recipe("frosthelmet", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("frosthood", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("frosthat", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("frostchestplate", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 16}}")));
        out.add(new Recipe("frostboots", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 8}}")));
        out.add(new Recipe("frostpickaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 10}}")));
        out.add(new Recipe("frostaxe", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 10}}")));
        out.add(new Recipe("frostshovel", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 10}}")));
        out.add(new Recipe("frostsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("frostgreatsword", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 20}}")));
        out.add(new Recipe("frostspear", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 15}}")));
        out.add(new Recipe("frostglaive", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 16}}")));
        out.add(new Recipe("frostboomerang", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("frostbow", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 12}}")));
        out.add(new Recipe("froststaff", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{frostshard, 16}, {batwing, 8}}")));
        out.add(new Recipe("sapphirestaff", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}, {goldbar, 4}, {sapphire, 3}}")));
        out.add(new Recipe("amethyststaff", 1, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}, {quartz, 6}, {amethyst, 4}}")));
        out.add(new Recipe("rubystaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}, {ectoplasm, 8}, {ruby, 5}}")));
        out.add(new Recipe("topazstaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}, {amber, 10}, {topaz, 6}}")));
        out.add(new Recipe("emeraldstaff", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{anylog, 8}, {myceliumore, 10}, {lifequartz, 2}, {emerald, 6}}")));
        out.add(new Recipe("woodshield", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 2}}")));
        out.add(new Recipe("hardenedshield", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{woodshield, 1}, {ironbar, 10}, {leather, 10}}")));
        out.add(new Recipe("revivalpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{firemone, 5}, {iceblossom, 5}, {sunflower, 5}, {mushroom, 5}, {cactussapling, 5}, {glassbottle, 1}}")));
        out.add(new Recipe("superiorhealthpotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{greaterhealthpotion, 1}, {alchemyshard, 4}}")));
        out.add(new Recipe("greaterhealthpotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{healthpotion, 1}, {caveglow, 1}}")));
        out.add(new Recipe("healthpotion", 2, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{sunflower, 3}, {glassbottle, 2}}")));
        out.add(new Recipe("superiormanapotion", 1, RecipeTechRegistry.FALLEN_ALCHEMY, Recipes.ingredientsFromScript("{{greatermanapotion, 1}, {alchemyshard, 2}}")));
        out.add(new Recipe("greatermanapotion", 1, RecipeTechRegistry.CAVEGLOW_ALCHEMY, Recipes.ingredientsFromScript("{{manapotion, 1}, {caveglow, 1}}")));
        out.add(new Recipe("manapotion", 2, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{sunflower, 1}, {blueberry, 4}, {glassbottle, 2}}")));
        out.add(new Recipe("battlepotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{terrorfish, 1}, {swampfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("healthregenpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{firemone, 5}, {glassbottle, 1}}")));
        out.add(new Recipe("manaregenpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{iceblossom, 5}, {glassbottle, 1}}")));
        out.add(new Recipe("speedpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{batwing, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("attackspeedpotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{voidshard, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("accuracypotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{firemone, 2}, {thorns, 3}, {glassbottle, 1}}")));
        out.add(new Recipe("rapidpotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{swampfish, 1}, {gobfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("resistancepotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{rockfish, 2}, {anystone, 10}, {glassbottle, 1}}")));
        out.add(new Recipe("knockbackpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{rockfish, 1}, {iceblossom, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("thornspotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{thorns, 4}, {mushroom, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("fireresistancepotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{icefish, 1}, {halffish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("invisibilitypotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{terrorfish, 2}, {icefish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("spelunkerpotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{voidshard, 2}, {goldbar, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("passivepotion", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{sunflower, 3}, {furfish, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("miningpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{batwing, 2}, {ironbar, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("buildingpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{clay, 4}, {mushroom, 1}, {glassbottle, 1}}")));
        out.add(new Recipe("fishingpotion", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{wormbait, 2}, {gobfish, 2}, {glassbottle, 1}}")));
        out.add(new Recipe("voidalchemytable", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript("{{glassbottle, 5}, {voidshard, 8}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("alchemytable", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{anylog, 10}, {healthpotion, 2}, {anystone, 10}}")).setCraftingCategory("finalcraftingstations"));
        out.add(new Recipe("sandtile", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{anystone, 5}}")).setCraftingCategory("materials"));
        out.add(new Recipe("glassbottle", 2, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript("{{glass, 1}}")));
        out.add(new Recipe("spideritearrow", 100, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{spideritebar, 1}}")));
        out.add(new Recipe("bonearrow", 10, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{bone, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("bouncingarrow", 25, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{stonearrow, 25}, {halffish, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("poisonarrow", 50, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{stonearrow, 50}, {cavespidergland, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("stonearrow", 5, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{anylog, 1}, {anystone, 5}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("ironarrow", 5, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("firearrow", 10, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{stonearrow, 10}, {torch, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("frostarrow", 10, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{stonearrow, 10}, {frostshard, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("crystalbullet", 100, RecipeTechRegistry.FALLEN_ANVIL, Recipes.ingredientsFromScript("{{sapphire, 1}}")));
        out.add(new Recipe("bouncingbullet", 50, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{simplebullet, 50}, {halffish, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("voidbullet", 100, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{simplebullet, 100}, {voidshard, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("sharktoothbullet", 100, RecipeTechRegistry.DEMONIC_ANVIL, Recipes.ingredientsFromScript("{{simplebullet, 100}, {sharktooth, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("simplebullet", 50, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("frostbullet", 50, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript("{{simplebullet, 50}, {frostshard, 1}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("cannonball", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, Recipes.ingredientsFromScript("{{ironbar, 1}, {handcannon, 0}}")).setCraftingCategory("equipment", "ammo"));
        out.add(new Recipe("torch", 4, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{anylog, 1}, {anysapling, 1}}")));
        out.add(new Recipe("workstationduo", 1, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("ladderdown", 1, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodboat", 1, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("ironbomb", 1, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{tilebomb, 1}}"), true));
        out.add(new Recipe("tilebomb", 1, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{ironbomb, 1}}"), true));
        out.add(new Recipe("stonearrow", 5, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{anylog, 1}, {anystone, 5}}")));
        out.add(new Recipe("snowball", 5, RecipeTechRegistry.NONE, Recipes.ingredientsFromScript("{{snowtile, 1}}"), true));
        out.add(new Recipe("forge", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 20}}")));
        out.add(new Recipe("ironanvil", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 5}}")));
        out.add(new Recipe("alchemytable", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {healthpotion, 2}, {anystone, 10}}")));
        out.add(new Recipe("carpentersbench", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 5}}")));
        out.add(new Recipe("campfire", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {anystone, 20}}")).setCraftingCategory("craftingstations"));
        out.add(new Recipe("roastingstation", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("cookingpot", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{clay, 10}, {ironbar, 4}}")));
        out.add(new Recipe("grainmill", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 20}, {wool, 10}, {ironbar, 10}}")));
        out.add(new Recipe("compostbin", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 20}, {ironbar, 5}}")));
        out.add(new Recipe("incinerator", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}, {clay, 10}}")));
        out.add(new Recipe("fallenworkstation", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{upgradeshard, 15}, {alchemyshard, 15}}")));
        out.add(new Recipe("tungstenworkstation", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{tungstenbar, 8}, {quartz, 4}}")));
        out.add(new Recipe("demonicworkstationduo", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{demonicbar, 5}}")));
        out.add(new Recipe("workstationduo", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodpickaxe", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodaxe", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodshovel", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("woodfishingrod", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 1}, {anysapling, 1}}")));
        out.add(new Recipe("woodsword", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodspear", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 15}}")));
        out.add(new Recipe("woodbow", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("woodboomerang", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("leatherdashers", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 10}, {wool, 5}}")));
        out.add(new Recipe("zephyrboots", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leatherdashers, 1}, {zephyrcharm, 1}}")));
        out.add(new Recipe("leatherglove", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 10}}")));
        out.add(new Recipe("trackerboot", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 10}, {ironbar, 2}}")));
        out.add(new Recipe("dreamcatcher", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anysapling, 5}, {wool, 5}}")));
        out.add(new Recipe("luckycape", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{fuzzydice, 1}, {noblehorseshoe, 1}}")));
        out.add(new Recipe("regenpendant", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{goldbar, 10}, {healthregenpotion, 5}}")));
        out.add(new Recipe("woodshield", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 2}}")));
        out.add(new Recipe("hardenedshield", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{woodshield, 1}, {ironbar, 10}, {leather, 10}}")));
        out.add(new Recipe("claygauntlet", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{clay, 25}}")));
        out.add(new Recipe("leatherhood", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 12}}")));
        out.add(new Recipe("leathershirt", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 16}}")));
        out.add(new Recipe("leatherboots", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{leather, 8}}")));
        out.add(new Recipe("clothhat", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{wool, 12}}")));
        out.add(new Recipe("clothrobe", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{wool, 16}}")));
        out.add(new Recipe("clothboots", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{wool, 8}}")));
        out.add(new Recipe("torch", 4, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 1}, {anysapling, 1}}")));
        out.add(new Recipe("ladderdown", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("cartographertable", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {mapfragment, 2}}")));
        out.add(new Recipe("storagebox", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("coolingbox", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 10}, {anystone, 10}, {frostshard, 5}}")));
        out.add(new Recipe("settlementflag", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 50}, {goldbar, 10}, {coin, 1000}}")));
        out.add(new Recipe("farmland", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 5}}")));
        out.add(new Recipe("feedingtrough", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 20}, {ironbar, 5}}")));
        out.add(new Recipe("eggnest", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{wheat, 10}}")));
        out.add(new Recipe("craftingguide", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 2}, {leather, 5}}")));
        out.add(new Recipe("sickle", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}, {anylog, 1}}")));
        out.add(new Recipe("shears", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}, {anylog, 1}}")));
        out.add(new Recipe("bucket", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 3}}")));
        out.add(new Recipe("steelboat", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{spareboatparts, 1}, {coin, 500}}")));
        out.add(new Recipe("woodboat", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("minecart", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}, {anylog, 10}}")));
        out.add(new Recipe("minecarttrack", 25, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 1}, {anylog, 1}}")).setCraftingCategory("misc"));
        out.add(new Recipe("landfill", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 2}}")));
        out.add(new Recipe("graveltile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 1}}")));
        out.add(new Recipe("sandgraveltile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{sandtile, 1}, {anystone, 1}}")));
        out.add(new Recipe("woodwall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 2}}")));
        out.add(new Recipe("wooddoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 4}}")));
        out.add(new Recipe("woodfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 1}}")));
        out.add(new Recipe("woodpathtile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 2}}")));
        out.add(new Recipe("woodfence", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 2}}")));
        out.add(new Recipe("woodfencegate", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 4}}")));
        out.add(new Recipe("stonefence", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 4}}")));
        out.add(new Recipe("stonefencegate", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 4}, {anylog, 2}}")));
        out.add(new Recipe("ironfence", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 1}}")));
        out.add(new Recipe("ironfencegate", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 4}}")));
        out.add(new Recipe("banditfence", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 2}}")));
        out.add(new Recipe("banditfencegate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 4}}")));
        out.add(new Recipe("pinewall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{pinelog, 2}}")));
        out.add(new Recipe("pinedoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{pinelog, 4}}")));
        out.add(new Recipe("pinefloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{pinelog, 1}}")));
        out.add(new Recipe("palmwall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{palmlog, 2}}")));
        out.add(new Recipe("palmdoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{palmlog, 4}}")));
        out.add(new Recipe("palmfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{palmlog, 1}}")));
        out.add(new Recipe("willowwall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{willowlog, 2}}")));
        out.add(new Recipe("willowdoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{willowlog, 4}}")));
        out.add(new Recipe("willowfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{willowlog, 1}}")));
        out.add(new Recipe("bamboowall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{bamboo, 2}}")));
        out.add(new Recipe("bamboodoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{bamboo, 4}}")));
        out.add(new Recipe("bamboofloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{bamboo, 1}}")));
        out.add(new Recipe("deadwoodfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deadwoodlog, 1}}")));
        out.add(new Recipe("strawtile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{wheat, 1}}")));
        out.add(new Recipe("stonewall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 5}}")));
        out.add(new Recipe("stonedoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 15}}")));
        out.add(new Recipe("stonefloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 1}}")));
        out.add(new Recipe("stonebrickfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 1}}")));
        out.add(new Recipe("stonetiledfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 1}}")));
        out.add(new Recipe("stonepathtile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{stone, 2}}")));
        out.add(new Recipe("brickwall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{clay, 2}}")));
        out.add(new Recipe("brickdoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("snowstonewall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 5}}")));
        out.add(new Recipe("snowstonedoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 15}}")));
        out.add(new Recipe("icewall", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 3}, {frostshard, 1}}")));
        out.add(new Recipe("icedoor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 10}, {frostshard, 1}}")));
        out.add(new Recipe("snowstonefloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 1}}")));
        out.add(new Recipe("snowstonebrickfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 1}}")));
        out.add(new Recipe("snowstonepathtile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 2}}")));
        out.add(new Recipe("granitewall", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{granite, 5}}")));
        out.add(new Recipe("granitedoor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{granite, 15}}")));
        out.add(new Recipe("granitefloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{granite, 1}}")));
        out.add(new Recipe("granitebrickfloor", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{granite, 1}}")));
        out.add(new Recipe("granitepathtile", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{granite, 2}}")));
        out.add(new Recipe("swampstonewall", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 5}}")));
        out.add(new Recipe("swampstonedoor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 15}}")));
        out.add(new Recipe("swampstonefloor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 1}}")));
        out.add(new Recipe("swampstonebrickfloor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 1}}")));
        out.add(new Recipe("swampstonepathtile", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 2}}")));
        out.add(new Recipe("sandstonewall", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 5}}")));
        out.add(new Recipe("sandstonedoor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 15}}")));
        out.add(new Recipe("sandstonefloor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 1}}")));
        out.add(new Recipe("sandstonebrickfloor", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 1}}")));
        out.add(new Recipe("sandstonepathtile", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 2}}")));
        out.add(new Recipe("deepstonewall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 5}}")));
        out.add(new Recipe("deepstonedoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 15}}")));
        out.add(new Recipe("deepstonefloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 1}}")));
        out.add(new Recipe("deepstonebrickfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 1}}")));
        out.add(new Recipe("deepstonetiledfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 1}}")));
        out.add(new Recipe("obsidianwall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{obsidian, 2}}")));
        out.add(new Recipe("obsidiandoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{obsidian, 8}}")));
        out.add(new Recipe("deepsnowstonewall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsnowstone, 5}}")));
        out.add(new Recipe("deepsnowstonedoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsnowstone, 15}}")));
        out.add(new Recipe("deepsnowstonefloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsnowstone, 1}}")));
        out.add(new Recipe("deepsnowstonebrickfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsnowstone, 1}}")));
        out.add(new Recipe("dryadwall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{dryadlog, 5}}")));
        out.add(new Recipe("dryaddoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{dryadlog, 15}}")));
        out.add(new Recipe("dryadfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{dryadlog, 1}}")));
        out.add(new Recipe("dryadpath", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{dryadlog, 2}}")));
        out.add(new Recipe("basaltwall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{basalt, 5}}")));
        out.add(new Recipe("basaltdoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{basalt, 15}}")));
        out.add(new Recipe("basaltfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{basalt, 1}}")));
        out.add(new Recipe("basaltpathtile", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{basalt, 2}}")));
        out.add(new Recipe("deepsandstonewall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsandstone, 5}}")));
        out.add(new Recipe("deepsandstonedoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsandstone, 15}}")));
        out.add(new Recipe("deepswampstonewall", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepswampstone, 5}}")));
        out.add(new Recipe("deepswampstonedoor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepswampstone, 15}}")));
        out.add(new Recipe("deepswampstonefloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepswampstone, 1}}")));
        out.add(new Recipe("deepswampstonebrickfloor", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepswampstone, 1}}")));
        out.add(new Recipe("cryptwall", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{cryptstone, 5}}")));
        out.add(new Recipe("cryptdoor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{cryptstone, 15}}")));
        out.add(new Recipe("spidercastlewall", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{spiderstone, 5}}")));
        out.add(new Recipe("spidercastledoor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{spiderstone, 15}}")));
        out.add(new Recipe("spidercastlefloor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{spiderstone, 1}}")));
        out.add(new Recipe("spidercastlecarpet", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{silk, 1}}")));
        out.add(new Recipe("ancientruinwall", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{crystalstone, 5}}")));
        out.add(new Recipe("ancientruindoor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{crystalstone, 15}}")));
        out.add(new Recipe("dawndoor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{dawnwall, 5}}")));
        out.add(new Recipe("duskdoor", 1, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{duskwall, 5}}")));
        out.add(new Recipe("ravenwall", 5, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 10}, {ravenfeather, 1}}")));
        out.add(new Recipe("ravendoor", 2, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 5}, {ravenfeather, 1}}")));
        out.add(new Recipe("ravenfloor", 5, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{ravenfeather, 2}}")));
        out.add(new Recipe("arcanicwall", 5, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 10}, {electrifiedmana, 1}}")));
        out.add(new Recipe("arcanicdoor", 2, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 5}, {electrifiedmana, 1}}")));
        out.add(new Recipe("arcanicfloor", 5, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{electrifiedmana, 2}}")));
        out.add(new Recipe("arcanicpath", 5, RecipeTechRegistry.FALLEN_WORKSTATION, Recipes.ingredientsFromScript("{{electrifiedmana, 2}}")));
        out.add(new Recipe("wallwindow", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript("{{glass, 5}}")));
        out.add(new Recipe("glass", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{sandtile, 1}}")));
        out.add(new Recipe("tungstenbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{tungstenore, 4}}")));
        out.add(new Recipe("glacialbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{glacialore, 4}}")));
        out.add(new Recipe("myceliumbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{myceliumore, 4}}")));
        out.add(new Recipe("ancientfossilbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{ancientfossilore, 4}}")));
        out.add(new Recipe("nightsteelbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{nightsteelore, 4}}")));
        out.add(new Recipe("spideritebar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{spideriteore, 4}}")));
        out.add(new Recipe("ironbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{ironore, 4}}")));
        out.add(new Recipe("ironbar", 2, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{brokenirontool, 1}}")));
        out.add(new Recipe("copperbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{copperore, 4}}")));
        out.add(new Recipe("copperbar", 2, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{brokencoppertool, 1}}")));
        out.add(new Recipe("goldbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{goldore, 4}}")));
        out.add(new Recipe("ivybar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript("{{ivyore, 4}}")));
        out.add(new Recipe("roastedfish", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{anycommonfish, 1}}")));
        out.add(new Recipe("roastedrabbitleg", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{rabbitleg, 1}}")));
        out.add(new Recipe("roastedduckbreast", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{duckbreast, 1}}")));
        out.add(new Recipe("roastedfrogleg", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{frogleg, 1}}")));
        out.add(new Recipe("steak", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{beef, 1}}")));
        out.add(new Recipe("roastedmutton", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{rawmutton, 1}}")));
        out.add(new Recipe("chickendrumstick", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{rawchickenleg, 1}}")));
        out.add(new Recipe("roastedpork", 1, RecipeTechRegistry.ROASTING_STATION, Recipes.ingredientsFromScript("{{rawpork, 1}}")));
        out.add(new Recipe("bread", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{flour, 2}}")));
        out.add(new Recipe("hardboiledegg", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{egg, 1}}")));
        out.add(new Recipe("friedegg", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{egg, 1}}")));
        out.add(new Recipe("candyapple", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{apple, 1}, {sugar, 2}}")));
        out.add(new Recipe("popcorn", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{corn, 4}}")));
        out.add(new Recipe("donut", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{flour, 1}, {milk, 1}, {sugar, 1}}")));
        out.add(new Recipe("cookies", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{flour, 2}, {milk, 2}, {sugar, 2}}")));
        out.add(new Recipe("raspberryjuice", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{raspberry, 2}, {honey, 1}}")));
        out.add(new Recipe("meatballs", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{anyrawmeat, 1}, {flour, 1}, {tomato, 1}}")));
        out.add(new Recipe("smokedfillet", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{anycommonfish, 1}, {cabbage, 1}, {chilipepper, 1}}")));
        out.add(new Recipe("blueberrycake", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{blueberry, 5}, {flour, 1}, {sugar, 1}}")));
        out.add(new Recipe("scrambledeggs", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{egg, 3}, {milk, 1}}")));
        out.add(new Recipe("cheesybeetbowl", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{cheese, 1}, {beet, 2}}")));
        out.add(new Recipe("blackberryicecream", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{blackberry, 4}, {milk, 2}, {sugar, 2}}")));
        out.add(new Recipe("fruitsmoothie", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{anyfruit, 4}, {milk, 2}, {coconut, 1}, {sugar, 1}}")));
        out.add(new Recipe("fishtaco", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{anycommonfish, 1}, {corn, 2}, {cabbage, 1}, {chilipepper, 1}}")));
        out.add(new Recipe("juniorburger", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{beef, 1}, {bread, 2}, {cabbage, 1}, {tomato, 2}}")));
        out.add(new Recipe("cheeseburger", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{beef, 1}, {bread, 2}, {cabbage, 1}, {tomato, 2}, {cheese, 2}}")));
        out.add(new Recipe("omelette", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{egg, 3}, {cheese, 2}, {tomato, 2}}")));
        out.add(new Recipe("nachos", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{corn, 2}, {flour, 1}, {cheese, 2}, {tomato, 2}, {chilipepper, 1}}")));
        out.add(new Recipe("eggplantparmesan", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{eggplant, 3}, {cheese, 2}, {tomato, 2}, {flour, 1}}")));
        out.add(new Recipe("raspberrymousse", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{raspberry, 5}, {milk, 4}, {sugar, 2}}")));
        out.add(new Recipe("tropicalstew", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{coconut, 2}, {eggplant, 2}, {chilipepper, 1}, {corn, 1}}")));
        out.add(new Recipe("fishandchips", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{anycommonfish, 1}, {potato, 4}, {flour, 1}, {tomato, 2}}")));
        out.add(new Recipe("freshpotatosalad", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{potato, 4}, {cabbage, 1}, {corn, 2}, {apple, 2}}")));
        out.add(new Recipe("rootsalad", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{carrot, 2}, {beet, 2}, {potato, 2}}")));
        out.add(new Recipe("hotdog", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{bread, 1}, {rawpork, 2}, {tomato, 2}, {onion, 1}}")));
        out.add(new Recipe("ricepudding", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rice, 4}, {milk, 2}, {sugar, 2}, {blueberry, 2}}")));
        out.add(new Recipe("minersstew", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{mushroom, 4}, {beet, 2}, {carrot, 2}, {eggplant, 2}, {tomato, 2}}")));
        out.add(new Recipe("chickencutletdish", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rawchickenleg, 2}, {milk, 1}, {bread, 1}, {mushroom, 3}, {egg, 1}}")));
        out.add(new Recipe("sushirolls", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rice, 4}, {anycommonfish, 1}, {eggplant, 2}, {carrot, 2}, {chilipepper, 2}}")));
        out.add(new Recipe("friedpork", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rawpork, 2}, {potato, 3}, {milk, 2}}")));
        out.add(new Recipe("dessertpancakes", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{milk, 2}, {egg, 2}, {sugar, 2}, {flour, 2}, {banana, 1}}")));
        out.add(new Recipe("bananapudding", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{banana, 4}, {milk, 2}, {sugar, 2}}")));
        out.add(new Recipe("lemontart", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{lemon, 4}, {flour, 2}, {milk, 2}, {sugar, 3}}")));
        out.add(new Recipe("parisiansteak", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{egg, 1}, {beef, 1}, {bread, 1}, {onion, 1}}")));
        out.add(new Recipe("deepfriedchicken", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rawchickenleg, 3}, {milk, 2}, {flour, 1}, {chilipepper, 1}, {onion, 1}}")));
        out.add(new Recipe("spaghettibolognese", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{flour, 2}, {beef, 2}, {tomato, 3}, {onion, 2}}")));
        out.add(new Recipe("porktenderloin", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{rawpork, 3}, {potato, 2}, {onion, 1}, {carrot, 1}, {eggplant, 1}}")));
        out.add(new Recipe("beefgoulash", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{beef, 2}, {tomato, 2}, {onion, 2}, {potato, 3}}")));
        out.add(new Recipe("shishkebab", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{beef, 1}, {rawpork, 1}, {tomato, 2}, {eggplant, 2}, {onion, 1}, {chilipepper, 1}}")));
        out.add(new Recipe("pumpkinpie", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{pumpkin, 2}, {flour, 2}, {milk, 2}, {sugar, 3}}")));
        out.add(new Recipe("sweetlemonade", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{lemon, 5}, {sugar, 3}}")));
        out.add(new Recipe("raspberryjam", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{glassbottle, 1}, {raspberry, 8}, {sugar, 6}, {lemon, 1}}")));
        out.add(new Recipe("raspberrypie", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{raspberry, 6}, {flour, 4}, {sugar, 2}, {lemon, 1}}")));
        out.add(new Recipe("strawberrypie", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{strawberry, 5}, {flour, 2}, {milk, 2}, {sugar, 3}}")));
        out.add(new Recipe("wildsalad", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{apple, 2}, {banana, 2}, {blueberry, 2}, {raspberry, 2}, {blackberry, 2}, {strawberry, 2}}")));
        out.add(new Recipe("blackcoffee", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{groundcoffee, 6}}")));
        out.add(new Recipe("cappuccino", 1, RecipeTechRegistry.COOKING_POT, Recipes.ingredientsFromScript("{{groundcoffee, 8}, {milk, 1}}")));
        out.add(new Recipe("sign", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("candle", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 1}, {honey, 1}}")));
        out.add(new Recipe("woodencandleset", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{anylog, 3}, {honey, 3}}")));
        out.add(new Recipe("basalttorch", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{basalt, 1}, {torch, 1}}")));
        out.add(new Recipe("tikitorch", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{torch, 1}, {anylog, 1}}")));
        out.add(new Recipe("firechalice", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{stone, 50}, {torch, 10}}")));
        out.add(new Recipe("waterlantern", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 4}, {torch, 1}}")));
        out.add(new Recipe("ironlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{ironbar, 3}}")));
        out.add(new Recipe("goldlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{goldbar, 3}}")));
        out.add(new Recipe("oillantern", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{copperbar, 1}}")));
        out.add(new Recipe("lantern", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{tungstenbar, 1}}")));
        out.add(new Recipe("fireflyjaryellow", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{emptyglassdisplay, 1}, {fireflyyellow, 3}}")));
        out.add(new Recipe("fireflyjargreen", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{emptyglassdisplay, 1}, {fireflygreen, 3}}")));
        out.add(new Recipe("fireflyjarblue", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{emptyglassdisplay, 1}, {fireflyblue, 3}}")));
        out.add(new Recipe("copperstreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{copperbar, 5}, {torch, 1}}")));
        out.add(new Recipe("copperdoublestreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{copperbar, 7}, {torch, 2}}")));
        out.add(new Recipe("ironstreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{ironbar, 5}, {torch, 1}}")));
        out.add(new Recipe("irondoublestreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{ironbar, 7}, {torch, 2}}")));
        out.add(new Recipe("goldstreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{goldbar, 5}, {torch, 1}}")));
        out.add(new Recipe("golddoublestreetlamp", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{goldbar, 7}, {torch, 2}}")));
        out.add(new Recipe("tungstenstreetlamp", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{tungstenbar, 5}, {torch, 1}}")));
        out.add(new Recipe("tungstendoublestreetlamp", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{tungstenbar, 7}, {torch, 2}}")));
        out.add(new Recipe("arcaniclamp", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{glass, 3}, {wire, 2}, {electrifiedmana, 1}}")));
        out.add(new Recipe("flowerpot", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 5}}")));
        out.add(new Recipe("barrel", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 8}}")));
        out.add(new Recipe("stool", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 4}, {leather,2}, {raspberry,1}}")));
        out.add(new Recipe("largekeg", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{anylog, 24}, {ironbar, 4}}")));
        out.add(new Recipe("barshelf", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{anylog, 12}, {glass,8}}")));
        out.add(new Recipe("demonchest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{demonicbar, 3}}")));
        out.add(new Recipe("woolcarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}}")));
        out.add(new Recipe("leathercarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{leather, 1}}")));
        out.add(new Recipe("brownbearcarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{leather, 2}}")));
        out.add(new Recipe("bluecarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {blueberry, 1}}")));
        out.add(new Recipe("goldgridcarpet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {goldore, 1}}")));
        out.add(new Recipe("greencarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {cabbage, 1}}")));
        out.add(new Recipe("heartcarpet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {healthpotion, 1}}")));
        out.add(new Recipe("purplecarpet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {blackberry, 1}}")));
        out.add(new Recipe("redyarncarpet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {chilipepper, 1}}")));
        out.add(new Recipe("steelgreycarpet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {ironore, 1}}")));
        out.add(new Recipe("velourcarpet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{wool, 1}, {eggplant, 1}}")));
        out.add(new Recipe("decorativepot1", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("decorativepot2", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("decorativepot3", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("decorativepot4", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("pottedcactus1", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {cactussapling, 1}}")));
        out.add(new Recipe("pottedcactus2", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {cactussapling, 1}}")));
        out.add(new Recipe("pottedcactus3", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {cactussapling, 1}}")));
        out.add(new Recipe("pottedcactus4", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {cactussapling, 1}}")));
        out.add(new Recipe("pottedflower1", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedflower2", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedflower3", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedflower4", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedflower5", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedflower6", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant1", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant2", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant3", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant4", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant5", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant6", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("pottedplant7", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anygrassseed, 1}}")));
        out.add(new Recipe("bonsaitree1", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anysapling, 1}}")));
        out.add(new Recipe("bonsaitree2", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{clay, 4}, {anysapling, 1}}")));
        out.add(new Recipe("woodcolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("stonecolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{stone, 20}}")));
        out.add(new Recipe("snowstonecolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowstone, 20}}")));
        out.add(new Recipe("granitecolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{granite, 20}}")));
        out.add(new Recipe("swampstonecolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{swampstone, 20}}")));
        out.add(new Recipe("sandstonecolumn", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sandstone, 20}}")));
        out.add(new Recipe("deepstonecolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{deepstone, 20}}")));
        out.add(new Recipe("obsidiancolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{obsidian, 5}}")));
        out.add(new Recipe("deepsnowstonecolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{deepsnowstone, 20}}")));
        out.add(new Recipe("basaltcolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{basalt, 20}}")));
        out.add(new Recipe("deepswampstonecolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{deepswampstone, 20}}")));
        out.add(new Recipe("deepsandstonecolumn", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{deepsandstone, 20}}")));
        out.add(new Recipe("arcaniccolumn", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{anystone, 15}, {electrifiedmana, 1}}")));
        out.add(new Recipe("stonecandlepedestal", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{stone, 20}, {honey, 1}}")));
        out.add(new Recipe("snowcandlepedestal", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowstone, 20}, {honey, 1}}")));
        out.add(new Recipe("swampcandlepedestal", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{swampstone, 20}, {honey, 1}}")));
        out.add(new Recipe("desertcandlepedestal", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sandstone, 20}, {honey, 1}}")));
        out.add(new Recipe("swampcandlestand", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{swampstone, 2}, {torch, 1}}")));
        out.add(new Recipe("swampcandlestandduo", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{swampstone, 3}, {torch, 2}}")));
        out.add(new Recipe("brazier", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{anystone, 15}, {torch, 5}}")));
        out.add(new Recipe("armorstand", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}}")));
        out.add(new Recipe("trainingdummy", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}, {wool, 10}}")));
        out.add(new Recipe("snowmantrainingdummy", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowtile, 10}, {anystone, 4}, {carrot, 1}}")));
        out.add(new Recipe("snowmantrainingdummy", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowball, 50}, {anystone, 4}, {carrot, 1}}")));
        out.add(new Recipe("frostbanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowstone, 5}, {wool, 2}, {snowball, 2}}")));
        out.add(new Recipe("largefrostbanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{snowstone, 10}, {wool, 4}, {snowball, 4}}")));
        out.add(new Recipe("piratebanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 5}, {wool, 2}, {goldore, 2}}")));
        out.add(new Recipe("largepiratebanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}, {wool, 4}, {goldore, 4}}")));
        out.add(new Recipe("eggcellentbanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 5}, {wool, 2}, {egg, 2}}")));
        out.add(new Recipe("largeeggcellentbanner", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}, {wool, 4}, {egg, 4}}")));
        out.add(new Recipe("dryadbanner", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 5}, {clothscraps, 2}, {dryadsapling, 1}}")));
        out.add(new Recipe("largedryadbanner", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}, {clothscraps, 4}, {dryadsapling   , 2}}")));
        out.add(new Recipe("fishianbanner", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 5}, {wool, 2}, {glowcoral, 1}}")));
        out.add(new Recipe("largefishianbanner", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}, {wool, 4}, {glowcoral, 2}, {seashell, 1}}")));
        out.add(new Recipe("vampiricbanner", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{ironbar, 2}, {batwing, 2}, {phantomdust, 1}}")));
        out.add(new Recipe("largevampiricbanner", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{ironbar, 4}, {batwing, 4}, {phantomdust, 2}}")));
        out.add(new Recipe("carpentersbench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{anylog, 10}, {ironbar, 5}}")).setCraftingCategory("objects", "misc"));
        out.add(new Recipe("tungstencarpentersbench", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{tungstenbar, 4}, {oaklog, 6}, {pinelog, 6}, {palmlog, 6}, {willowlog, 6}, {maplelog, 6}, {birchlog, 6}}")).setCraftingCategory("objects", "misc"));
        out.add(new Recipe("fallencarpentersbench", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 12}, {bone, 6}, {bamboo, 5}, {upgradeshard, 5}}")).setCraftingCategory("objects", "misc"));
        out.add(new Recipe("oakchest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 8}}")));
        out.add(new Recipe("oakdinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 16}}")));
        out.add(new Recipe("oakdesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 8}}")));
        out.add(new Recipe("oakmodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 8}}")));
        out.add(new Recipe("oakchair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 4}}")));
        out.add(new Recipe("oakbench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 10}}")));
        out.add(new Recipe("oakbookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 10}}")));
        out.add(new Recipe("oakcabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 10}}")));
        out.add(new Recipe("oakbed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 10}, {wool, 10}}")));
        out.add(new Recipe("oakdoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 20}, {wool, 20}}")));
        out.add(new Recipe("oakdresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 8}}")));
        out.add(new Recipe("oakclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("oakcandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 6}, {torch, 3}}")));
        out.add(new Recipe("oakdisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 10}}")));
        out.add(new Recipe("oakbathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 12}}")));
        out.add(new Recipe("oaktoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{oaklog, 6}}")));
        out.add(new Recipe("sprucechest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 8}}")));
        out.add(new Recipe("sprucedinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 16}}")));
        out.add(new Recipe("sprucedesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 8}}")));
        out.add(new Recipe("sprucemodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 8}}")));
        out.add(new Recipe("sprucechair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 4}}")));
        out.add(new Recipe("sprucebench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 10}}")));
        out.add(new Recipe("sprucebookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 10}}")));
        out.add(new Recipe("sprucecabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 10}}")));
        out.add(new Recipe("sprucebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 10}, {wool, 10}}")));
        out.add(new Recipe("sprucedoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 20}, {wool, 20}}")));
        out.add(new Recipe("sprucedresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 8}}")));
        out.add(new Recipe("spruceclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("sprucecandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 6}, {torch, 3}}")));
        out.add(new Recipe("sprucedisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 10}}")));
        out.add(new Recipe("sprucebathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 12}}")));
        out.add(new Recipe("sprucetoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{sprucelog, 6}}")));
        out.add(new Recipe("pinechest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 8}}")));
        out.add(new Recipe("pinedinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 16}}")));
        out.add(new Recipe("pinedesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 8}}")));
        out.add(new Recipe("pinemodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 8}}")));
        out.add(new Recipe("pinechair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 4}}")));
        out.add(new Recipe("pinebench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 10}}")));
        out.add(new Recipe("pinebookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 10}}")));
        out.add(new Recipe("pinecabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 10}}")));
        out.add(new Recipe("pinebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 10}, {wool, 10}}")));
        out.add(new Recipe("pinedoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 20}, {wool, 20}}")));
        out.add(new Recipe("pinedresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 8}}")));
        out.add(new Recipe("pineclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("pinecandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 6}, {torch, 3}}")));
        out.add(new Recipe("pinedisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 10}}")));
        out.add(new Recipe("pinebathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 12}}")));
        out.add(new Recipe("pinetoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{pinelog, 6}}")));
        out.add(new Recipe("palmchest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 8}}")));
        out.add(new Recipe("palmdinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 16}}")));
        out.add(new Recipe("palmdesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 8}}")));
        out.add(new Recipe("palmmodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 8}}")));
        out.add(new Recipe("palmchair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 4}}")));
        out.add(new Recipe("palmbench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 10}}")));
        out.add(new Recipe("palmbookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 10}}")));
        out.add(new Recipe("palmcabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 10}}")));
        out.add(new Recipe("palmbed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 10}, {wool, 10}}")));
        out.add(new Recipe("palmdoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 20}, {wool, 20}}")));
        out.add(new Recipe("palmdresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 8}}")));
        out.add(new Recipe("palmclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("palmcandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 6}, {torch, 3}}")));
        out.add(new Recipe("palmdisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 10}}")));
        out.add(new Recipe("palmbathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 12}}")));
        out.add(new Recipe("palmtoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{palmlog, 6}}")));
        out.add(new Recipe("willowchest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 8}}")));
        out.add(new Recipe("willowdinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 16}}")));
        out.add(new Recipe("willowdesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 8}}")));
        out.add(new Recipe("willowmodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 8}}")));
        out.add(new Recipe("willowchair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 4}}")));
        out.add(new Recipe("willowbench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 10}}")));
        out.add(new Recipe("willowbookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 10}}")));
        out.add(new Recipe("willowcabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 10}}")));
        out.add(new Recipe("willowbed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 10}, {wool, 10}}")));
        out.add(new Recipe("willowdoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 20}, {wool, 20}}")));
        out.add(new Recipe("willowdresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 8}}")));
        out.add(new Recipe("willowclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("willowcandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 6}, {torch, 3}}")));
        out.add(new Recipe("willowdisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 10}}")));
        out.add(new Recipe("willowbathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 12}}")));
        out.add(new Recipe("willowtoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{willowlog, 6}}")));
        out.add(new Recipe("maplechest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 8}}")));
        out.add(new Recipe("mapledinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 16}}")));
        out.add(new Recipe("mapledesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 8}}")));
        out.add(new Recipe("maplemodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 8}}")));
        out.add(new Recipe("maplechair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 4}}")));
        out.add(new Recipe("maplebench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 10}}")));
        out.add(new Recipe("maplebookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 10}}")));
        out.add(new Recipe("maplecabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 10}}")));
        out.add(new Recipe("maplebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 10}, {wool, 10}}")));
        out.add(new Recipe("mapledoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 20}, {wool, 20}}")));
        out.add(new Recipe("mapledresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 8}}")));
        out.add(new Recipe("mapleclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("maplecandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 6}, {torch, 3}}")));
        out.add(new Recipe("mapledisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 10}}")));
        out.add(new Recipe("maplebathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 12}}")));
        out.add(new Recipe("mapletoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{maplelog, 6}}")));
        out.add(new Recipe("birchchest", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 8}}")));
        out.add(new Recipe("birchdinnertable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 16}}")));
        out.add(new Recipe("birchdesk", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 8}}")));
        out.add(new Recipe("birchmodulartable", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 8}}")));
        out.add(new Recipe("birchchair", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 4}}")));
        out.add(new Recipe("birchbench", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 10}}")));
        out.add(new Recipe("birchbookshelf", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 10}}")));
        out.add(new Recipe("birchcabinet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 10}}")));
        out.add(new Recipe("birchbed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 10}, {wool, 10}}")));
        out.add(new Recipe("birchdoublebed", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 20}, {wool, 20}}")));
        out.add(new Recipe("birchdresser", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 8}}")));
        out.add(new Recipe("birchclock", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("birchcandelabra", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 6}, {torch, 3}}")));
        out.add(new Recipe("birchdisplay", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 10}}")));
        out.add(new Recipe("birchbathtub", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 12}}")));
        out.add(new Recipe("birchtoilet", 1, RecipeTechRegistry.CARPENTER, Recipes.ingredientsFromScript("{{birchlog, 6}}")));
        out.add(new Recipe("bonechest", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 8}}")));
        out.add(new Recipe("bonedinnertable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 16}}")));
        out.add(new Recipe("bonedesk", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 8}}")));
        out.add(new Recipe("bonemodulartable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 8}}")));
        out.add(new Recipe("bonechair", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 4}}")));
        out.add(new Recipe("bonebench", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 10}}")));
        out.add(new Recipe("bonebookshelf", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 10}}")));
        out.add(new Recipe("bonecabinet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 10}}")));
        out.add(new Recipe("bonebed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 10}, {wool, 10}}")));
        out.add(new Recipe("bonedoublebed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 20}, {wool, 20}}")));
        out.add(new Recipe("bonedresser", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 8}}")));
        out.add(new Recipe("boneclock", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 8}, {ironbar, 2}}")));
        out.add(new Recipe("bonecandelabra", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 6}, {torch, 3}}")));
        out.add(new Recipe("bonedisplay", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 10}}")));
        out.add(new Recipe("bonebathtub", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 12}}")));
        out.add(new Recipe("bonetoilet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bone, 6}}")));
        out.add(new Recipe("dryadchest", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 8}}")));
        out.add(new Recipe("dryaddinnertable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 16}}")));
        out.add(new Recipe("dryaddesk", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 8}}")));
        out.add(new Recipe("dryadmodulartable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 8}}")));
        out.add(new Recipe("dryadchair", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 4}}")));
        out.add(new Recipe("dryadbench", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}}")));
        out.add(new Recipe("dryadbookshelf", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}}")));
        out.add(new Recipe("dryadcabinet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}}")));
        out.add(new Recipe("dryadbed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}, {wool, 10}}")));
        out.add(new Recipe("dryaddoublebed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 20}, {wool, 20}}")));
        out.add(new Recipe("dryaddresser", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 8}}")));
        out.add(new Recipe("dryadclock", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("dryadcandelabra", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 6}, {torch, 3}}")));
        out.add(new Recipe("dryaddisplay", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 10}}")));
        out.add(new Recipe("dryadbathtub", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 12}}")));
        out.add(new Recipe("dryadtoilet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{dryadlog, 6}}")));
        out.add(new Recipe("bamboochest", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 8}}")));
        out.add(new Recipe("bamboodinnertable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 16}}")));
        out.add(new Recipe("bamboodesk", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 8}}")));
        out.add(new Recipe("bamboomodulartable", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 8}}")));
        out.add(new Recipe("bamboochair", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 4}}")));
        out.add(new Recipe("bamboobench", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}}")));
        out.add(new Recipe("bamboobookshelf", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}}")));
        out.add(new Recipe("bamboocabinet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}}")));
        out.add(new Recipe("bamboobed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}, {wool, 10}}")));
        out.add(new Recipe("bamboodoublebed", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 20}, {wool, 20}}")));
        out.add(new Recipe("bamboodresser", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 8}}")));
        out.add(new Recipe("bambooclock", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 8}, {ironbar, 2}}")));
        out.add(new Recipe("bamboocandelabra", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 6}, {torch, 3}}")));
        out.add(new Recipe("bamboodisplay", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 10}}")));
        out.add(new Recipe("bamboobathtub", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 12}}")));
        out.add(new Recipe("bambootoilet", 1, RecipeTechRegistry.TUNGSTEN_CARPENTER, Recipes.ingredientsFromScript("{{bamboo, 6}}")));
        out.add(new Recipe("deadwoodchest", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 8}}")));
        out.add(new Recipe("deadwooddinnertable", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 16}}")));
        out.add(new Recipe("deadwooddesk", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 8}}")));
        out.add(new Recipe("deadwoodmodulartable", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 8}}")));
        out.add(new Recipe("deadwoodchair", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 4}}")));
        out.add(new Recipe("deadwoodbench", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 10}}")));
        out.add(new Recipe("deadwoodbookshelf", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 10}}")));
        out.add(new Recipe("deadwoodcabinet", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 10}}")));
        out.add(new Recipe("deadwoodbed", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 10}, {wool, 10}}")));
        out.add(new Recipe("deadwooddoublebed", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 20}, {wool, 20}}")));
        out.add(new Recipe("deadwooddresser", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 8}}")));
        out.add(new Recipe("deadwoodclock", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 8}, {ironbar, 2}}")));
        out.add(new Recipe("deadwoodcandelabra", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 6}, {torch, 3}}")));
        out.add(new Recipe("deadwooddisplay", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 10}}")));
        out.add(new Recipe("deadwoodbathtub", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 12}}")));
        out.add(new Recipe("deadwoodtoilet", 1, RecipeTechRegistry.FALLEN_CARPENTER, Recipes.ingredientsFromScript("{{deadwoodlog, 6}}")));
        out.add(new Recipe("paintingbroken", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 5}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("foresthedge", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{oaksapling, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("foresthedgegate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{oaksapling, 1}, {oaklog, 2}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("snowhedge", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{pinesapling, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("snowhedgegate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{pinesapling, 1}, {pinelog, 2}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("plainshedge", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{maplesapling, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("plainshedgegate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{maplesapling, 1}, {maplelog, 2}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("swamphedge", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{willowsapling, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("swamphedgegate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{willowsapling, 1}, {willowlog, 2}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("grass", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{grassseed, 1}}")));
        out.add(new Recipe("plainsgrass", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{plainsgrassseed, 1}}")));
        out.add(new Recipe("swampgrass", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampgrassseed, 1}}")));
        out.add(new Recipe("deepswampgrass", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{swampgrassseed, 1}}")));
        out.add(new Recipe("deepswamptallgrass", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{swampgrassseed, 1}}")));
        out.add(new Recipe("cryptgrass", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{grassseed, 1}}")));
        out.add(new Recipe("grassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{overgrowngrassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("overgrowngrassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{grassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("swampgrassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{overgrownswampgrassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("overgrownswampgrassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampgrassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("plainsgrassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{overgrownplainsgrassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("overgrownplainsgrassseed", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{plainsgrassseed, 1}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("oaktreestump", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{oaklog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("sprucetreestump", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sprucelog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("willowtreestump", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{willowlog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("sprucelogbench", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sprucelog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("willowlogbench", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{willowlog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("dryadlogbench", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{dryadlog, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("bamboologbench", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bamboo, 4}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("leafpile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{maplelog, 2}}")));
        out.add(new Recipe("cobweb", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{silk, 1}}")));
        out.add(new Recipe("swamproot", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 8}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("bamboodebris", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bamboo, 2}}")).setCraftingCategory("objects", "landscaping", "plants"));
        out.add(new Recipe("clayrock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{clay, 4}}")));
        out.add(new Recipe("surfacerocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 20}}")));
        out.add(new Recipe("surfacerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 30}}")));
        out.add(new Recipe("caverocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 20}}")));
        out.add(new Recipe("caverock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 30}}")));
        out.add(new Recipe("rock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 4}}")));
        out.add(new Recipe("copperorerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironorerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldorerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 4}, {goldore, 2}}")));
        out.add(new Recipe("rocktile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 2}}")).setCraftingCategory("objects", "landscaping", "forestrocksandores"));
        out.add(new Recipe("sapphireclustersmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sapphire, 1}}")));
        out.add(new Recipe("sapphirecluster", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sapphire, 2}}")));
        out.add(new Recipe("sapphireclusterpure", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sapphire, 2}}")));
        out.add(new Recipe("sapphiregravel", 5, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sapphire, 1}}")));
        out.add(new Recipe("snowsurfacerocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 20}}")));
        out.add(new Recipe("snowsurfacerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 30}}")));
        out.add(new Recipe("snowcaverocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 20}}")));
        out.add(new Recipe("snowcaverock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 30}}")));
        out.add(new Recipe("snowrock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 4}}")));
        out.add(new Recipe("copperoresnow", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoresnow", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoresnow", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("frostshardsnow", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 4}, {frostshard, 1}}")));
        out.add(new Recipe("snowrocktile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowstone, 2}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("swampsurfacerocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 20}}")));
        out.add(new Recipe("swampsurfacerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 30}}")));
        out.add(new Recipe("swampcaverocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 20}}")));
        out.add(new Recipe("swampcaverock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 30}}")));
        out.add(new Recipe("swamprock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}}")));
        out.add(new Recipe("copperoreswamp", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoreswamp", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoreswamp", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("ivyoreswamp", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}, {ivyore, 2}}")));
        out.add(new Recipe("swamprocktile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 2}}")).setCraftingCategory("objects", "landscaping", "swamprocksandores"));
        out.add(new Recipe("sandsurfacerocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 20}}")));
        out.add(new Recipe("sandsurfacerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 30}}")));
        out.add(new Recipe("sandcaverocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 20}}")));
        out.add(new Recipe("sandcaverock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 30}}")));
        out.add(new Recipe("sandstonerock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 4}}")));
        out.add(new Recipe("copperoresandstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoresandstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoresandstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("quartzsandstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 4}, {quartz, 1}}")));
        out.add(new Recipe("sandstonetile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 2}}")).setCraftingCategory("objects", "landscaping", "desertrocksandores"));
        out.add(new Recipe("sandbrick", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sandstone, 2}}")).setCraftingCategory("objects", "landscaping", "desertrocksandores"));
        out.add(new Recipe("amethystclustersmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{amethyst, 1}}")));
        out.add(new Recipe("amethystcluster", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{amethyst, 2}}")));
        out.add(new Recipe("amethystclusterpure", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{amethyst, 2}}")));
        out.add(new Recipe("amethystgravel", 5, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{amethyst, 1}}")));
        out.add(new Recipe("granitecaverocksmall", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 20}}")));
        out.add(new Recipe("granitecaverock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 30}}")));
        out.add(new Recipe("graniterock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 4}}")));
        out.add(new Recipe("copperoregraniterock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoregraniterock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoregraniterock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 4}, {goldore, 2}}")));
        out.add(new Recipe("runicboulder", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{runestone, 4}}")));
        out.add(new Recipe("smallrunestone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{runestone, 1}}")));
        out.add(new Recipe("graniterocktile", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{granite, 2}}")).setCraftingCategory("objects", "landscaping", "plainsrocksandores"));
        out.add(new Recipe("deepcaverocksmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 20}}")));
        out.add(new Recipe("deepcaverock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 30}}")));
        out.add(new Recipe("deeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}}")));
        out.add(new Recipe("copperoredeeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoredeeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoredeeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("tungstenoredeeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {tungstenore, 2}}")));
        out.add(new Recipe("lifequartzdeeprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {lifequartz, 1}}")));
        out.add(new Recipe("obsidianrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{obsidian, 4}}")));
        out.add(new Recipe("deeprocktile", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 2}}")).setCraftingCategory("objects", "landscaping", "forestrocksandores"));
        out.add(new Recipe("rubyclustersmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ruby, 1}}")));
        out.add(new Recipe("rubycluster", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ruby, 2}}")));
        out.add(new Recipe("rubyclusterpure", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ruby, 2}}")));
        out.add(new Recipe("rubygravel", 5, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ruby, 1}}")));
        out.add(new Recipe("deepsnowcaverocksmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 20}}")));
        out.add(new Recipe("deepsnowcaverock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 30}}")));
        out.add(new Recipe("deepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}}")));
        out.add(new Recipe("copperoredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("tungstenoredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {tungstenore, 2}}")));
        out.add(new Recipe("lifequartzdeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {lifequartz, 1}}")));
        out.add(new Recipe("glacialoredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {glacialore, 2}}")));
        out.add(new Recipe("deepsnowrocktile", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 2}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("fallenicicle", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 20}}")));
        out.add(new Recipe("snowpile0", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowball, 1}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("snowpile1", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowball, 2}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("snowpile2", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowball, 3}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("snowpile3", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{snowball, 4}}")).setCraftingCategory("objects", "landscaping", "snowrocksandores"));
        out.add(new Recipe("basaltcaverocksmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 20}}")));
        out.add(new Recipe("basaltcaverock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 30}}")));
        out.add(new Recipe("basaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}}")));
        out.add(new Recipe("copperorebasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironorebasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldorebasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {goldore, 2}}")));
        out.add(new Recipe("tungstenorebasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {tungstenore, 2}}")));
        out.add(new Recipe("lifequartzbasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {lifequartz, 1}}")));
        out.add(new Recipe("amberbasaltrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 4}, {amber, 2}}")));
        out.add(new Recipe("basaltrocktile", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 2}}")).setCraftingCategory("objects", "landscaping", "plainsrocksandores"));
        out.add(new Recipe("topazclustersmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{topaz, 1}}")));
        out.add(new Recipe("topazcluster", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{topaz, 2}}")));
        out.add(new Recipe("topazclusterpure", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{topaz, 2}}")));
        out.add(new Recipe("topazgravel", 5, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{topaz, 1}}")));
        out.add(new Recipe("deepswampcaverocksmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 20}}")));
        out.add(new Recipe("deepswampcaverock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 30}}")));
        out.add(new Recipe("deepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}}")));
        out.add(new Recipe("copperoredeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoredeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoredeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("tungstenoredeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {tungstenore, 2}}")));
        out.add(new Recipe("lifequartzdeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {lifequartz, 1}}")));
        out.add(new Recipe("myceliumoredeepswamprock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {myceliumore, 2}}")));
        out.add(new Recipe("deepswamprocktile", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 2}}")).setCraftingCategory("objects", "landscaping", "swamprocksandores"));
        out.add(new Recipe("emeraldclustersmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{emerald, 1}}")));
        out.add(new Recipe("emeraldcluster", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{emerald, 2}}")));
        out.add(new Recipe("emeraldclusterpure", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{emerald, 2}}")));
        out.add(new Recipe("emeraldgravel", 5, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{emerald, 1}}")));
        out.add(new Recipe("deepsandcaverocksmall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 20}}")));
        out.add(new Recipe("deepsandcaverock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 30}}")));
        out.add(new Recipe("deepsandstonerock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}}")));
        out.add(new Recipe("copperoredeepsandstonerock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {copperore, 2}}")));
        out.add(new Recipe("ironoredeepsandstonerock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {ironore, 2}}")));
        out.add(new Recipe("goldoredeepsandstonerock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {goldore, 2}}")));
        out.add(new Recipe("ancientfossiloredeepsnowrock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {ancientfossilore, 2}}")));
        out.add(new Recipe("lifequartzdeepsandstonerock", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {lifequartz, 1}}")));
        out.add(new Recipe("deepsandstonetile", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 2}}")).setCraftingCategory("objects", "landscaping", "desertrocksandores"));
        out.add(new Recipe("upgradesharddeeprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemysharddeeprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("shadowessencedeeprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepstone, 4}, {shadowessence, 1}}")));
        out.add(new Recipe("upgradesharddeepsnowrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemysharddeepsnowrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("cryoessencedeepsnowrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsnowstone, 4}, {cryoessence, 1}}")));
        out.add(new Recipe("upgradesharddeepswamprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemysharddeepswamprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("bioessencedeepswamprock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepswampstone, 4}, {bioessence, 1}}")));
        out.add(new Recipe("upgradesharddeepsandstonerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemysharddeepsandstonerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("primordialessencedeepsandstonerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{deepsandstone, 4}, {primordialessence, 1}}")));
        out.add(new Recipe("slimecaverocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 20}}")));
        out.add(new Recipe("slimecaverock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 30}}")));
        out.add(new Recipe("slimerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 4}}")));
        out.add(new Recipe("slimeumslimerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 4}, {slimeum, 5}}")));
        out.add(new Recipe("upgradeshardslimerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemyshardslimerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("slimeessenceslimerock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 4}, {slimeessence, 1}}")));
        out.add(new Recipe("slimerocktile", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{slimestone, 2}}")).setCraftingCategory("objects", "landscaping", "incursionrocksandores"));
        out.add(new Recipe("cryptnightsteelorerocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 20}, {nightsteelore, 5}}")));
        out.add(new Recipe("cryptupgradeshardorerocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 20}, {upgradeshard, 4}}")));
        out.add(new Recipe("cryptalchemyshardorerocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 20}, {alchemyshard, 4}}")));
        out.add(new Recipe("bloodessenceoreorerocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 20}, {bloodessence, 4}}")));
        out.add(new Recipe("cryptpath", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 2}}")).setCraftingCategory("objects", "landscaping", "incursionrocksandores"));
        out.add(new Recipe("spidercaverocksmall", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 20}}")));
        out.add(new Recipe("spidercaverock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 30}}")));
        out.add(new Recipe("spiderrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 4}}")));
        out.add(new Recipe("spideritespiderrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 4}, {spideriteore, 1}}")));
        out.add(new Recipe("upgradeshardspiderrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemyshardspiderrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("spideressencespiderrock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 4}, {spideressence, 1}}")));
        out.add(new Recipe("spidercobbletile", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spiderstone, 2}}")).setCraftingCategory("objects", "landscaping", "incursionrocksandores"));
        out.add(new Recipe("crystal", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{crystalstone, 4}}")));
        out.add(new Recipe("pearlescentshard", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{pearlescentdiamond, 1}}")));
        out.add(new Recipe("upgradeshardcrystal", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{crystalstone, 4}, {upgradeshard, 1}}")));
        out.add(new Recipe("alchemyshardcrystal", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{crystalstone, 4}, {alchemyshard, 1}}")));
        out.add(new Recipe("omnicrystalcrystal", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{crystalstone, 4}, {omnicrystal, 1}}")));
        out.add(new Recipe("crystaltile", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{crystalstone, 2}}")).setCraftingCategory("objects", "landscaping", "incursionrocksandores"));
        out.add(new Recipe("crate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{sprucelog, 4}}")));
        out.add(new Recipe("snowcrate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{pinelog, 4}}")));
        out.add(new Recipe("swampcrate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{willowlog, 4}}")));
        out.add(new Recipe("arcaniccrate", 2, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ironbar, 2}, {electrifiedmana, 1}}")));
        out.add(new Recipe("christmascrate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 2}, {anywrappingpaper, 1, true}}")));
        out.add(new Recipe("steppingstones", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 2}}")));
        out.add(new Recipe("largesteppingstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 3}}")));
        out.add(new Recipe("mossysteppingstones", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 2}}")));
        out.add(new Recipe("largemossysteppingstone", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 3}}")));
        out.add(new Recipe("vase", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{clay, 2}}")));
        out.add(new Recipe("sink", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 8}, {clay, 2}, {ironbar, 2}}")));
        out.add(new Recipe("tungstensink", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{tungstenbar, 4}, {clay, 2}, {ironbar, 2}}")));
        out.add(new Recipe("fountain", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 75}, {watertile, 5}}")));
        out.add(new Recipe("bloodfountain", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 75}, {watertile, 5}, {raspberry, 10}}")));
        out.add(new Recipe("ravenstatue", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 30}, {ravenfeather, 2}}")));
        out.add(new Recipe("pigstatue", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 75}, {rawpork, 75}, {roastedpork, 50}, {friedpork, 25}, {porktenderloin, 25}}")));
        out.add(new Recipe("blacksmithstatue", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 75}, {tungstenbar, 50}, {glacialbar, 45}, {amber, 40}, {myceliumbar, 35}, {ancientfossilbar, 30}}")));
        out.add(new Recipe("witchstatue", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 75}, {greaterhealthregenpotion, 15}, {greatermanaregenpotion, 15}, {greaterbattlepotion, 10}, {greaterspeedpotion, 10}, {greaterattackspeedpotion, 10}, {greaterresistancepotion, 10}, {greateraccuracypotion, 5} , {greaterrapidpotion, 5}}")));
        out.add(new Recipe("hoodedknightstatue", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 35}}")));
        out.add(new Recipe("angelicstatue", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 35}}")));
        out.add(new Recipe("mossymonkstatue", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 40}}")));
        out.add(new Recipe("stonecoffin", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 20}}")));
        out.add(new Recipe("gravestone1", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 5}}")));
        out.add(new Recipe("gravestone2", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 5}}")));
        out.add(new Recipe("cryptcoffin", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 20}}")));
        out.add(new Recipe("basaltcoffin", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 20}}")));
        out.add(new Recipe("cryptgravestone1", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 5}}")));
        out.add(new Recipe("cryptgravestone2", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{cryptstone, 5}}")));
        out.add(new Recipe("katanastone", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{stone, 20}, {katana, 1}}")));
        out.add(new Recipe("utensilrack1", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 2}, {ironbar, 1}}")));
        out.add(new Recipe("utensilrack2", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 2}, {ironbar, 1}}")));
        out.add(new Recipe("bigtent", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{wool, 6}, {leather, 8}, {clothscraps, 5}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("merchantsbackpack", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{wool, 8}, {blueberry, 3}, {chilipepper, 2}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("picnicblanket", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{heartcarpet, 3}, {wheat, 2}, {apple, 2}, {bread, 1}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("sack", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{wool, 3}, {leather, 1}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("bonespikewall", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 4}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("cowskeleton", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 2}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("bloodstains", 3, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{watertile, 1}, {raspberry, 5}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("raveneffigy", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 40}, {clothscraps, 15}, {ravenfeather, 8}, {ravenskull, 1}}")));
        out.add(new Recipe("ravenskull", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 10}, {ravenfeather, 1}}")));
        out.add(new Recipe("emptyravennest", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 10}, {grass, 5}, {ravenfeather, 1}}")));
        out.add(new Recipe("ravennestwithegg", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 10}, {grass, 5}, {ravenfeather, 1}, {egg, 1}}")));
        out.add(new Recipe("spideregg", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{silk, 5}}")));
        out.add(new Recipe("spideritearmorstand", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{spideritebar, 2}}")));
        out.add(new Recipe("arcanicmachinery", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ironbar, 10}, {electrifiedmana, 4}, {arcaniclamp, 1}}")));
        out.add(new Recipe("cryptash", 5, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 5}, {batwing, 2}}")));
        out.add(new Recipe("spidernesttile", 5, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 5}, {cavespidergland, 2}}")));
        out.add(new Recipe("ascendedvoid", 10, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ascendedshard, 1}}")));
        out.add(new Recipe("landscapingstation", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 20}, {anylog, 15}, {firemone, 4}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("tungstenlandscapingstation", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{tungstenbar, 5}, {obsidian, 8}, {caveglow, 3}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("fallenlandscapingstation", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{basalt, 12}, {emerald, 6}, {alchemyshard, 5}}")).setCraftingCategory("objects", "landscaping", "misc"));
        out.add(new Recipe("tableclock", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 5}, {copperbar, 1}}")));
        out.add(new Recipe("duelistclock", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 10}, {copperbar, 4}, {clothscraps, 2}, {ironbar, 2}}")));
        out.add(new Recipe("swampstonecase", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 5}}")));
        out.add(new Recipe("dryadspiritcage", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{dryadlog, 5}}")));
        out.add(new Recipe("dogplush", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{wool, 4}, {firemone, 2}, {beef, 1}}")));
        out.add(new Recipe("dinoplush", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{leather, 4}, {swampsludge, 2}, {frogleg, 1}}")));
        out.add(new Recipe("observantmask", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 4}, {chilipepper, 2}}")));
        out.add(new Recipe("unamusedmask", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 4}, {chilipepper, 2}}")));
        out.add(new Recipe("voidcube", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}, {voidshard, 2}}")));
        out.add(new Recipe("farseersorb", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 3}, {ironbar, 1}, {cabbage, 1}, {blueberry, 1}}")));
        out.add(new Recipe("largeglobe", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 5}, {ironbar, 2}, {cabbage, 2}, {blackberry, 2}}")));
        out.add(new Recipe("fishonastick", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{ironbar, 1}, {torch, 1}, {carp, 1}}")));
        out.add(new Recipe("relicofthedepths", 1, RecipeTechRegistry.FALLEN_LANDSCAPING, Recipes.ingredientsFromScript("{{swampstone, 4}, {deepswampstone, 2}, {swampsludge, 2}, {swampfish, 1}}")));
        out.add(new Recipe("stackofpaper", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 3}}")));
        out.add(new Recipe("quillandparchment", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 1}, {anylog, 1}, {blackberry, 1}}")));
        out.add(new Recipe("greenandpinkbooks", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 2}, {cabbage, 1}}")));
        out.add(new Recipe("redbooks", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 2}, {firemone, 1}}")));
        out.add(new Recipe("blueandyellowbooks", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 2}, {iceblossom, 1}, {sunflower, 1}}")));
        out.add(new Recipe("yellowbook", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 1}, {sunflower, 1}}")));
        out.add(new Recipe("greenbook", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 1}, {cabbage, 1}}")));
        out.add(new Recipe("orangebook", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 1}, {carrot, 1}}")));
        out.add(new Recipe("stackedbooks", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{stackofpaper, 3}, {firemone, 1}, {blackberry, 1}}")));
        out.add(new Recipe("emptyglassdisplay", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}}")));
        out.add(new Recipe("beetglassdisplay", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}, {beet, 1}}")));
        out.add(new Recipe("brokenherbglassdisplay", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 1}, {anygrassseed, 1}}")));
        out.add(new Recipe("caveglowglassdisplay", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}, {caveglow, 1}}")));
        out.add(new Recipe("brokenglassdisplay", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 1}}")));
        out.add(new Recipe("testtubes", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 3}, {ironbar, 1}, {sunflower, 1}, {voidshard, 1}}")));
        out.add(new Recipe("voidflaskandtesttube", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}, {ironbar, 1}, {voidshard, 2}}")));
        out.add(new Recipe("voidflasks", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 2}, {voidshard, 1}}")));
        out.add(new Recipe("blueberryandcornextract", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 3}, {blueberry, 1}, {corn, 1}}")));
        out.add(new Recipe("caveglowflask", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{glass, 1}, {caveglow, 1}}")));
        out.add(new Recipe("experimentalroot", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{thorns, 2}, {batwing, 1}, {swamplarva, 1}}")));
        out.add(new Recipe("plate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}, {ironbar, 1}}")));
        out.add(new Recipe("diningset", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 2}, {ironbar, 1}}")));
        out.add(new Recipe("bluediningset", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 2}, {ironbar, 1}, {blueberry, 1}}")));
        out.add(new Recipe("reddiningset", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 2}, {ironbar, 1}, {raspberry, 1}}")));
        out.add(new Recipe("mug", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}}")));
        out.add(new Recipe("teapot", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 3}, {honey, 1}}")));
        out.add(new Recipe("dirtyplate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}}")));
        out.add(new Recipe("dirtydishes", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 3}}")));
        out.add(new Recipe("stewpot", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{ironbar, 2}}")));
        out.add(new Recipe("cuttingboard", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 2}, {ironbar, 1}}")));
        out.add(new Recipe("stuffedpig", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{rawpork, 5}, {goldbar, 1}, {apple, 1}}")));
        out.add(new Recipe("roastedduck", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{duckbreast, 6}, {goldbar, 1}}")));
        out.add(new Recipe("papertowel", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anylog, 3}}")));
        out.add(new Recipe("bloodgoblet", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{goldbar, 2}}")));
        out.add(new Recipe("goldchalice", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{goldbar, 1}}")));
        out.add(new Recipe("bloodgobletspilled", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{goldbar, 2}}")));
        out.add(new Recipe("spilledgoldchalice", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{goldbar, 1}}")));
        out.add(new Recipe("oldchalices", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 2}}")));
        out.add(new Recipe("oldplate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}}")));
        out.add(new Recipe("brokenplate", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}}")));
        out.add(new Recipe("rottenpigdish", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}, {rawpork, 2}, {spoiledfood, 1}}")));
        out.add(new Recipe("rottenfishstew", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}, {trout, 1}, {spoiledfood, 1}}")));
        out.add(new Recipe("oldsoup", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 1}, {watertile, 1}, {spoiledfood, 1}}")));
        out.add(new Recipe("halfeatenduck", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{duckbreast, 2}, {bone, 2}, {spoiledfood, 1}}")));
        out.add(new Recipe("leftovertray", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 5}, {bone, 1}, {spoiledfood, 1}}")));
        out.add(new Recipe("simplesculpture", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 10}}")));
        out.add(new Recipe("forgottenblade", 1, RecipeTechRegistry.LANDSCAPING, Recipes.ingredientsFromScript("{{anystone, 5}}")));
        out.add(new Recipe("skull", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 2}}")));
        out.add(new Recipe("mosscoveredskull", 1, RecipeTechRegistry.TUNGSTEN_LANDSCAPING, Recipes.ingredientsFromScript("{{bone, 2}, {grass, 1}}")));
        out.add(new Recipe("wrench", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}}")));
        out.add(new Recipe("cutter", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 10}}")));
        out.add(new Recipe("wire", 10, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}}")));
        out.add(new Recipe("woodpressureplate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anylog, 5}, {wire, 5}}")));
        out.add(new Recipe("stonepressureplate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{stone, 10}, {wire, 5}}")));
        out.add(new Recipe("snowstonepressureplate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{snowstone, 10}, {wire, 5}}")));
        out.add(new Recipe("swampstonepressureplate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{swampstone, 10}, {wire, 5}}")));
        out.add(new Recipe("sandstonepressureplate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{sandstone, 10}, {wire, 5}}")));
        out.add(new Recipe("deepstonepressureplate", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepstone, 10}, {wire, 5}}")));
        out.add(new Recipe("deepsnowstonepressureplate", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepsnowstone, 10}, {wire, 5}}")));
        out.add(new Recipe("deepswampstonepressureplate", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{deepswampstone, 10}, {wire, 5}}")));
        out.add(new Recipe("basaltpressureplate", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{basalt, 10}, {wire, 5}}")));
        out.add(new Recipe("rocklever", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{anystone, 10}, {wire, 5}}")));
        out.add(new Recipe("ledpanel", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{torch, 5}, {wire, 5}, {ironbar, 2}}")));
        out.add(new Recipe("fireworkdispenser", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 5}, {wire, 10}}")));
        out.add(new Recipe("tnt", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript("{{dynamitestick, 4}, {wire, 10}}")));
        out.add(new Recipe("andgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}, {wire, 5}}")));
        out.add(new Recipe("nandgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}, {wire, 5}}")));
        out.add(new Recipe("orgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}, {wire, 5}}")));
        out.add(new Recipe("norgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}, {wire, 5}}")));
        out.add(new Recipe("xorgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{copperbar, 1}, {wire, 5}}")));
        out.add(new Recipe("srlatchgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{norgate, 2}, {wire, 5}}")));
        out.add(new Recipe("tflipflopgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{norgate, 1}, {andgate, 1}, {wire, 5}}")));
        out.add(new Recipe("countergate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("timergate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("delaygate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("buffergate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("sensorgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("soundgate", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript("{{ironbar, 2}, {wire, 10}}")));
        out.add(new Recipe("fertilizer", 1, RecipeTechRegistry.COMPOST_BIN, Recipes.ingredientsFromScript("{{anycompostable, 2}}")));
        out.add(new Recipe("spoiledfood", 1, RecipeTechRegistry.COMPOST_BIN, Recipes.ingredientsFromScript("{{anycookedfood, 1}}")));
        out.add(new Recipe("groundcoffee", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript("{{coffeebeans, 1}}")));
        out.add(new Recipe("rice", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript("{{riceseed, 1}}")));
        out.add(new Recipe("flour", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript("{{wheat, 1}}")));
        out.add(new Recipe("sugar", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript("{{sugarbeet, 1}}")));
        out.add(new Recipe("sugar", 2, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript("{{honey, 1}}")));
        out.add(new Recipe("cheese", 1, RecipeTechRegistry.CHEESE_PRESS, Recipes.ingredientsFromScript("{{milk, 1}}")));
        return out;
    }
}

