/*
 * Decompiled with CFR 0.152.
 */
package necesse.inventory.container.settlement.actions;

import java.util.ArrayList;
import java.util.Collection;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.server.ServerClient;
import necesse.inventory.container.settlement.SettlementContainer;
import necesse.inventory.container.settlement.actions.CommandSettlersCustomAction;
import necesse.inventory.container.settlement.events.SettlementSettlerGroupDeletedEvent;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.levelData.settlementData.SettlementSettlerGroup;
import necesse.level.maps.levelData.settlementData.settler.CommandMob;

public class CommandSettlersGroupAddOrRemoveAction
extends CommandSettlersCustomAction {
    public CommandSettlersGroupAddOrRemoveAction(SettlementContainer container) {
        super(container);
    }

    public void runAndSend(Collection<Integer> mobUniqueIDs, int groupUniqueID, boolean addToGroup) {
        PacketWriter writer = this.setupPacket(mobUniqueIDs);
        writer.putNextInt(groupUniqueID);
        writer.putNextBoolean(addToGroup);
        this.runAndSendAction(writer.getPacket());
    }

    @Override
    public void executePacket(PacketReader reader, ServerSettlementData data, ServerClient client, ArrayList<CommandMob> mobs) {
        int groupUniqueID = reader.getNextInt();
        boolean addToGroup = reader.getNextBoolean();
        SettlementSettlerGroup group = data.groups.getGroup(groupUniqueID);
        if (group == null) {
            new SettlementSettlerGroupDeletedEvent(data, groupUniqueID).applyAndSendToClient(client);
            return;
        }
        ArrayList<Integer> mobUniqueIDs = new ArrayList<Integer>(mobs.size());
        for (CommandMob commandMob : mobs) {
            mobUniqueIDs.add(commandMob.getMob().getUniqueID());
        }
        if (addToGroup) {
            group.addMobUniqueIDs(mobUniqueIDs, true);
        } else {
            group.removeMobUniqueIDs(mobUniqueIDs, true);
        }
    }
}

